<?php

namespace app\controllers;

use app\models\Application;
use app\models\Comment;
use app\models\CommentForm;
use app\models\Tour;
use app\models\TourSearch;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

class CatalogController extends Controller
{
    public function actionIndex()
    {
        $searchModel = new TourSearch();
        $searchModel->load(Yii::$app->request->get());

        $query = Tour::find();

        if ($searchModel->validate()) {
            if ($searchModel->min_price !== null && $searchModel->min_price !== '') {
                $query->andWhere(['>=', 'price', $searchModel->min_price]);
            }

            if ($searchModel->max_price !== null && $searchModel->max_price !== '') {
                $query->andWhere(['<=', 'price', $searchModel->max_price]);
            }

            if ($searchModel->date_from !== null && $searchModel->date_from !== '') {
                $query->andWhere(['>=', 'date_start', $searchModel->date_from]);
            }

            if ($searchModel->date_to !== null && $searchModel->date_to !== '') {
                $query->andWhere(['<=', 'date_end', $searchModel->date_to]);
            }
        }

        $sort = Yii::$app->request->get('sort', 'date_start');
        $order = Yii::$app->request->get('order', 'asc');

        if (in_array($sort, ['date_start', 'date_end', 'price']) && in_array($order, ['asc', 'desc'])) {
            $query->orderBy([$sort => ($order === 'desc' ? SORT_DESC : SORT_ASC)]);
        }

        $tours = $query->all();

        return $this->render('index', [
            'tours' => $tours,
            'model' => $searchModel,
        ]);
    }

    public function actionView($id)
    {
        $tour = Tour::findOne($id);

        if (!$tour) {
            throw new NotFoundHttpException('Тур не найден.');
        }

        $comment = new CommentForm();
        $comment->tour_id = $id;

        if ($comment->load(Yii::$app->request->post()) && $comment->save()) {
            Yii::$app->session->setFlash('success', 'Ваш комментарий добавлен!');
            return $this->refresh();
        }

        return $this->render('view', [
            'tour' => $tour,
            'comment' => $comment,
        ]);
    }

    public function pluralForm($number, $titles)
    {
        $cases = [2, 0, 1, 1, 1, 2];
        return $titles[($number % 100 > 4 && $number % 100 < 20) ? 2 : $cases[min($number % 10, 5)]];
    }
}