<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%application}}`.
 */
class m251216_154939_create_application_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%application}}', [
            'id' => $this->primaryKey(),
            'tour_id' => $this->integer()->notNull(),
            'date_start' => $this->date()->notNull(),
            'date_end' => $this->date()->notNull(),
            'count' => $this->integer()->notNull(),
            'additional' => $this->text()->notNull(),
            'payment' => $this->integer()->notNull(),
            'user_id' => $this->integer()->notNull(),
        ]);
        $this->addForeignKey(
            'fk_application_tour',
            'application',
            'tour_id',
            'tour',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk_application_user',
            'application',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%application}}');
    }
}
