<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property int $tour_id
 * @property string $date_start
 * @property string $date_end
 * @property int $count
 * @property string $additional
 * @property int $payment
 * @property int $user_id
 * @property int $status
 *
 * @property Tour $tour
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{
    const STATUS_NEW = 0;
    const STATUS_IN_REVIEW = 1;
    const STATUS_ACCEPTED = 2;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['tour_id', 'date_start', 'date_end', 'count', 'payment', 'user_id'], 'required'],
            [['tour_id', 'count', 'payment', 'user_id', 'status'], 'integer'],
            [['date_start', 'date_end'], 'safe'],
            [['additional'], 'string'],
            [['tour_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tour::class, 'targetAttribute' => ['tour_id' => 'id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            ['status', 'default', 'value' => self::STATUS_NEW],
            ['status', 'in', 'range' => [self::STATUS_NEW, self::STATUS_IN_REVIEW, self::STATUS_ACCEPTED]],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tour_id' => 'Тур',
            'date_start' => 'Дата начала',
            'date_end' => 'Дата окончания',
            'count' => 'Количество человек',
            'additional' => 'Дополнительная информация',
            'payment' => 'Оплата',
            'user_id' => 'Пользователь',
            'status' => 'Статус',
        ];
    }

    /**
     * Получить массив статусов
     */
    public static function getStatuses()
    {
        return [
            self::STATUS_NEW => 'Новая',
            self::STATUS_IN_REVIEW => 'На рассмотрении',
            self::STATUS_ACCEPTED => 'Заявка принята',
        ];
    }

    /**
     * Получить текстовое представление статуса
     */
    public function getStatusText()
    {
        $statuses = self::getStatuses();
        return isset($statuses[$this->status]) ? $statuses[$this->status] : 'Неизвестно';
    }

    /**
     * Gets query for [[Tour]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTour()
    {
        return $this->hasOne(Tour::class, ['id' => 'tour_id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
}