<?php

namespace app\models;

use Yii;
use yii\base\Model;

class RegisterForm extends Model
{
    public $first_name;
    public $last_name;
    public $patronymic;
    public $phone;
    public $email;
    public $passport;
    public $address;
    public $password;
    public $password_repeat;
    public $rules;

    public function rules()
    {
        return [
            [['first_name', 'last_name', 'patronymic', 'phone', 'email', 'passport', 'address', 'password', 'password_repeat', 'rules'], 'required'],
            ['email', 'email'],
            ['rules', 'boolean'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password'],
            [['password', 'password_repeat'], 'string', 'min' => 7],
            [['first_name', 'last_name', 'patronymic'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u'],
            ['rules', 'compare', 'compareValue' => true, 'message' => 'Вы должны согласиться с правилами'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'first_name' => 'Имя',
            'last_name' => 'Фамилия',
            'patronymic' => 'Отчество',
            'phone' => 'Телефон',
            'passport' => 'Серия и номер паспорта',
            'address' => 'Адрес',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'rules' => 'Соглашение с правилами',
        ];
    }

    public function register()
    {
        if ($this->validate()) {
            $user = new User();
            $user->first_name = $this->first_name;
            $user->last_name = $this->last_name;
            $user->patronymic = $this->patronymic;
            $user->phone = $this->phone;
            $user->email = $this->email;
            $user->passport = $this->passport;
            $user->address = $this->address;
            $user->password = Yii::$app->getSecurity()->generatePasswordHash($this->password);
            if ($user->save()){
                return $user;
            }
        }
        return null;
    }
}
