<?php

namespace app\models;

use yii\base\Model;

class TourSearch extends Model
{
    public $min_price;
    public $max_price;
    public $date_from;
    public $date_to;

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['min_price', 'max_price'], 'integer', 'min' => 0],
            [['date_from', 'date_to'], 'date', 'format' => 'php:Y-m-d'],
            ['max_price', 'compare', 'compareAttribute' => 'min_price', 'operator' => '>=',
                'when' => function($model) {
                    return !empty($model->min_price) && !empty($model->max_price);
                },
                'message' => 'Максимальная цена должна быть больше минимальной'
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'min_price' => 'Минимальная цена',
            'max_price' => 'Максимальная цена',
            'date_from' => 'Дата начала от',
            'date_to' => 'Дата окончания до',
        ];
    }
}