<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>

<?php $this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
<?php $this->registerCssFile('https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&display=swap') ?>

<style>
:root {
    --bg: #fcfdfd;
    --surface: #ffffff;
    --text: #2a2f3a;
    --text-light: #6c757d;
    --primary: #4ecdc4;
    --primary-light: #b0e5e1;
    --secondary: #6c5ce7;
    --shadow-sm: 0 4px 12px rgba(0,0,0,0.03);
    --shadow-md: 0 8px 24px rgba(0,0,0,0.05);
    --radius: 20px;
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Manrope', sans-serif;
    background-color: var(--bg);
    color: var(--text);
}

.admin-index {
    min-height: calc(100vh - 160px);
    padding: 60px 0;
}

.admin-header {
    text-align: center;
    margin-bottom: 60px;
}

.admin-title {
    font-size: 2.6rem;
    font-weight: 700;
    margin-bottom: 16px;
    background: linear-gradient(135deg, var(--text), var(--primary));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    display: inline-block;
}

.admin-subtitle {
    color: var(--text-light);
    font-size: 1.05rem;
    max-width: 600px;
    margin: 0 auto;
    line-height: 1.6;
}

.admin-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 32px;
    max-width: 1100px;
    margin: 0 auto;
    padding: 0 20px;
}

.admin-card {
    background: var(--surface);
    border-radius: var(--radius);
    padding: 40px 30px;
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
    position: relative;
    overflow: hidden;
    text-align: center;
}

.admin-card:hover {
    transform: translateY(-8px);
    box-shadow: var(--shadow-md);
}

.card-icon {
    width: 72px;
    height: 72px;
    background: var(--primary-light);
    border-radius: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 24px;
    color: var(--primary);
    font-size: 2rem;
    transition: var(--transition);
}

.admin-card:hover .card-icon {
    transform: scale(1.1) rotate(3deg);
    background: var(--primary);
    color: white;
}

.card-title {
    font-size: 1.35rem;
    font-weight: 600;
    margin-bottom: 16px;
    color: var(--text);
}

.card-text {
    color: var(--text-light);
    font-size: 0.95rem;
    line-height: 1.6;
    margin-bottom: 28px;
}

.card-btn {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 12px 28px;
    background: transparent;
    color: var(--primary);
    border: 2px solid var(--primary);
    border-radius: 50px;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.95rem;
    transition: var(--transition);
}

.card-btn:hover {
    background: var(--primary);
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(78, 205, 196, 0.25);
}

/* Анимация при загрузке */
.admin-card {
    opacity: 0;
    transform: translateY(20px);
}

.admin-card.visible {
    opacity: 1;
    transform: translateY(0);
    transition: opacity 0.5s ease, transform 0.5s ease;
}

/* Адаптивность */
@media (max-width: 768px) {
    .admin-title { font-size: 2.0rem; }
    .admin-grid { padding: 0 15px; }
    .admin-card { padding: 32px 24px; }

    .card-icon {
        width: 64px;
        height: 64px;
        font-size: 1.8rem;
    }

    .card-title { font-size: 1.25rem; }
}

@media (max-width: 576px) {
    .admin-title { font-size: 1.7rem; }
    .admin-subtitle { font-size: 1rem; }
    .card-btn { width: 100%; justify-content: center; }
}
</style>

<div class="admin-index">
    <div class="admin-header">
        <h1 class="admin-title">Панель администратора</h1>
        <p class="admin-subtitle">Управление системой бронирования туров</p>
    </div>

    <div class="admin-grid">
        <div class="admin-card">
            <div class="card-icon">
                <i class="fas fa-file-alt"></i>
            </div>
            <h3 class="card-title">Заявки</h3>
            <p class="card-text">Управление заявками от пользователей, просмотр статусов и обработка бронирований</p>
            <?= Html::a('<i class="fas fa-arrow-right"></i><span>Перейти к заявкам</span>', ['applications'], ['class' => 'card-btn']) ?>
        </div>

        <div class="admin-card">
            <div class="card-icon">
                <i class="fas fa-plane"></i>
            </div>
            <h3 class="card-title">Туры</h3>
            <p class="card-text">Управление турами: создание, редактирование, удаление и обновление информации</p>
            <?= Html::a('<i class="fas fa-arrow-right"></i><span>Управление турами</span>', ['tours'], ['class' => 'card-btn']) ?>
        </div>

        <div class="admin-card">
            <div class="card-icon">
                <i class="fas fa-users"></i>
            </div>
            <h3 class="card-title">Пользователи</h3>
            <p class="card-text">Управление данными пользователей, просмотр активности и настройка прав доступа</p>
            <?= Html::a('<i class="fas fa-arrow-right"></i><span>Управление пользователями</span>', ['users'], ['class' => 'card-btn']) ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.admin-card');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.classList.add('visible');
        }, 200 + index * 150);
    });
});
</script>