<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = $model->isNewRecord ? 'Создать тур' : 'Редактировать тур';
$this->params['breadcrumbs'][] = ['label' => 'Туры', 'url' => ['tours']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-tour-form">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

    <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'price')->textInput() ?>

    <?= $form->field($model, 'date_start')->input('date') ?>

    <?= $form->field($model, 'date_end')->input('date') ?>

    <?= $form->field($model, 'imageFile')->fileInput() ?>

    <?php if (!$model->isNewRecord && $model->image): ?>
        <div class="form-group">
            <label>Текущее изображение</label><br>
            <img src="<?= Yii::getAlias('@web/images/') . $model->image ?>" style="max-width: 300px; max-height: 200px; object-fit: cover;">
        </div>
    <?php endif; ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Создать' : 'Сохранить', ['class' => 'btn btn-success']) ?>
        <?= Html::a('Отмена', ['tours'], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>