<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Туры';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-tours">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3">
            <i class="bi bi-globe me-2 text-primary"></i><?= Html::encode($this->title) ?>
        </h1>
        <?= Html::a('<i class="bi bi-plus-circle me-1"></i> Создать новый тур', ['create-tour'], [
            'class' => 'btn btn-success btn-lg px-4 shadow-sm'
        ]) ?>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'tableOptions' => ['class' => 'table table-hover align-middle mb-0'],
                'layout' => "{items}\n<div class='card-footer d-flex justify-content-between align-items-center px-3 py-2'>{summary}\n{pager}</div>",
                'columns' => [
                    [
                        'class' => 'yii\grid\SerialColumn',
                        'headerOptions' => ['style' => 'width: 5%; text-align: center;'],
                        'contentOptions' => ['style' => 'text-align: center;'],
                    ],
                    [
                        'attribute' => 'id',
                        'headerOptions' => ['style' => 'width: 8%;'],
                        'contentOptions' => ['class' => 'fw-bold text-muted'],
                    ],
                    [
                        'attribute' => 'title',
                        'format' => 'raw',
                        'value' => function ($model) {
                            return Html::tag('div', Html::encode($model->title), [
                                'class' => 'fw-bold text-break',
                                'style' => 'max-width: 250px;'
                            ]);
                        },
                        'headerOptions' => ['style' => 'width: 30%;'],
                    ],
                    [
                        'attribute' => 'price',
                        'format' => 'raw',
                        'value' => function ($model) {
                            return Html::tag('span', number_format($model->price, 0, '', ' ') . ' ₽', [
                                'class' => 'badge bg-success fw-bold fs-6 px-3 py-2',
                                'style' => 'font-size: 1rem;'
                            ]);
                        },
                        'headerOptions' => ['style' => 'width: 15%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center'],
                    ],
                    [
                        'attribute' => 'date_start',
                        'format' => ['date', 'php:d M Y'],
                        'headerOptions' => ['style' => 'width: 12%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center text-nowrap'],
                    ],
                    [
                        'attribute' => 'date_end',
                        'format' => ['date', 'php:d M Y'],
                        'headerOptions' => ['style' => 'width: 12%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center text-nowrap'],
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'template' => '{update} {delete}',
                        'header' => 'Действия',
                        'headerOptions' => ['style' => 'width: 18%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center'],
                        'buttons' => [
                            'update' => function ($url, $model, $key) {
                                return Html::a(
                                    '<i class="bi bi-pencil-square"></i> Редактировать',
                                    ['update-tour', 'id' => $model->id],
                                    [
                                        'class' => 'btn btn-sm btn-outline-primary me-1',
                                        'title' => 'Редактировать тур'
                                    ]
                                );
                            },
                            'delete' => function ($url, $model, $key) {
                                return Html::a(
                                    '<i class="bi bi-trash"></i> Удалить',
                                    ['delete-tour', 'id' => $model->id],
                                    [
                                        'class' => 'btn btn-sm btn-outline-danger',
                                        'title' => 'Удалить тур',
                                        'data' => [
                                            'confirm' => 'Вы уверены, что хотите удалить тур «' . $model->title . '»?',
                                            'method' => 'post',
                                        ],
                                    ]
                                );
                            },
                        ],
                    ],
                ],
            ]); ?>
        </div>
    </div>
</div>

<?php
// Подключаем Bootstrap Icons (если ещё не подключены в layout)
$this->registerCss('@import url("https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css");');
?>