<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Пользователи';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-users">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3">
            <i class="bi bi-people-fill me-2 text-info"></i><?= Html::encode($this->title) ?>
        </h1>
        <?= Html::a('<i class="bi bi-person-plus me-1"></i> Добавить пользователя', ['create-user'], [
            'class' => 'btn btn-success btn-lg px-4 shadow-sm'
        ]) ?>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'tableOptions' => ['class' => 'table table-hover align-middle mb-0'],
                'layout' => "{items}\n<div class='card-footer d-flex justify-content-between align-items-center px-3 py-2'>{summary}\n{pager}</div>",
                'columns' => [
                    [
                        'class' => 'yii\grid\SerialColumn',
                        'headerOptions' => ['style' => 'width: 5%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center text-muted'],
                    ],
                    [
                        'attribute' => 'id',
                        'headerOptions' => ['style' => 'width: 8%;'],
                        'contentOptions' => ['class' => 'fw-bold text-muted text-center'],
                    ],
                    [
                        'label' => 'ФИО',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $fio = trim("{$model->last_name} {$model->first_name} {$model->patronymic}");
                            if (empty($fio)) $fio = '—';
                            return Html::tag('div', Html::encode($fio), [
                                'class' => 'fw-bold text-break',
                                'style' => 'max-width: 200px;',
                                'title' => $fio
                            ]);
                        },
                        'headerOptions' => ['style' => 'width: 22%;'],
                    ],
                    // ——— или, если хочешь оставить отдельно first_name/last_name — раскомментируй ниже и закомментируй блок выше ———
                    /*
                    'first_name',
                    'last_name',
                    [
                        'attribute' => 'patronymic',
                        'label' => 'Отчество',
                        'value' => function ($model) {
                            return $model->patronymic ?: '—';
                        },
                    ],
                    */

                    [
                        'attribute' => 'email',
                        'format' => 'email',
                        'contentOptions' => ['class' => 'text-break', 'style' => 'max-width: 180px;'],
                        'headerOptions' => ['style' => 'width: 18%;'],
                    ],
                    [
                        'attribute' => 'phone',
                        'value' => function ($model) {
                            return $model->phone ? Html::tag('span', Html::encode($model->phone), ['class' => 'text-nowrap']) : '—';
                        },
                        'headerOptions' => ['style' => 'width: 12%;'],
                        'contentOptions' => ['class' => 'text-nowrap'],
                    ],
                    [
                        'attribute' => 'is_admin',
                        'format' => 'raw',
                        'value' => function ($model) {
                            if ($model->is_admin) {
                                return Html::tag('span', '<i class="bi bi-shield-check me-1"></i> Админ', [
                                    'class' => 'badge bg-success px-3 py-2',
                                    'style' => 'font-size: 0.875rem;'
                                ]);
                            }
                            return Html::tag('span', 'Пользователь', [
                                'class' => 'badge bg-secondary px-3 py-2',
                                'style' => 'font-size: 0.875rem;'
                            ]);
                        },
                        'headerOptions' => ['style' => 'width: 12%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center'],
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'template' => '{update} {delete}',
                        'header' => 'Действия',
                        'headerOptions' => ['style' => 'width: 18%; text-align: center;'],
                        'contentOptions' => ['class' => 'text-center'],
                        'buttons' => [
                            'update' => function ($url, $model) {
                                return Html::a(
                                    '<i class="bi bi-pencil-square"></i>',
                                    ['update-user', 'id' => $model->id],
                                    [
                                        'class' => 'btn btn-sm btn-outline-primary me-1',
                                        'title' => 'Редактировать',
                                        'aria-label' => 'Редактировать'
                                    ]
                                );
                            },
                            'delete' => function ($url, $model) {
                                return Html::a(
                                    '<i class="bi bi-trash"></i>',
                                    ['delete-user', 'id' => $model->id],
                                    [
                                        'class' => 'btn btn-sm btn-outline-danger',
                                        'title' => 'Удалить',
                                        'aria-label' => 'Удалить',
                                        'data' => [
                                            'confirm' => "Вы уверены, что хотите удалить пользователя:\n"
                                                . trim("{$model->last_name} {$model->first_name}") . " ({$model->email})?",
                                            'method' => 'post',
                                        ],
                                    ]
                                );
                            },
                        ],
                    ],
                ],
            ]); ?>
        </div>
    </div>
</div>

<?php
$this->registerCss('@import url("https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css");');
?>