<?php
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Application;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Заявки', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-view-application">
    <h1><?= Html::encode($this->title) ?></h1>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            [
                'attribute' => 'tour_id',
                'value' => $model->tour ? $model->tour->title : 'Не указано',
            ],
            [
                'attribute' => 'user_id',
                'value' => function($model) {
                    return $model->user ? $model->user->getFullName() . ' (' . $model->user->email . ')' : 'Не указано';
                },
            ],
            'date_start:date',
            'date_end:date',
            'count',
            'additional',
            [
                'attribute' => 'payment',
                'value' => $model->payment ? 'Оплачено' : 'Не оплачено',
            ],
            [
                'attribute' => 'status',
                'value' => $model->getStatusText(),
            ],
        ],
    ]) ?>

    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Изменить статус</h5>
        </div>
        <div class="card-body">
            <form method="post">
                <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->csrfToken) ?>
                <div class="form-group">
                    <select name="status" class="form-control">
                        <?php foreach (Application::getStatuses() as $value => $label): ?>
                            <option value="<?= $value ?>" <?= $model->status == $value ? 'selected' : '' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?= Html::submitButton('Сохранить статус', ['class' => 'btn btn-primary']) ?>
            </form>
        </div>
    </div>

    <div class="mt-3">
        <?= Html::a('Назад к списку', ['applications'], ['class' => 'btn btn-secondary']) ?>
    </div>
</div>