<?php

use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use yii\helpers\Url;

$this->title = 'Отправка комментария';
?>
<style>
    :root {
        --dark-green: #1a535c;
        --mint: #4ecdc4;
        --cream: #f7fff7;
        --coral: #ff6b6b;
        --yellow: #ffe66d;
        --dark: #292f36;
        --gray: #6c757d;
        --light-gray: #e8f4f8;
        --border-color: #e0e6eb;
    }

    .comment-page {
        min-height: calc(100vh - 200px);
        padding: 80px 0;
        background: linear-gradient(135deg, #f7fff7 0%, #e8f4f8 100%);
        position: relative;
        overflow: hidden;
    }

    .comment-container {
        max-width: 1000px;
        margin: 0 auto;
        padding: 0 30px;
        position: relative;
        z-index: 1;
    }

    /* Геометрические элементы */
    .comment-shapes {
        position: absolute;
        z-index: 0;
    }

    .shape-comment-1 {
        width: 300px;
        height: 300px;
        border: 3px solid rgba(78, 205, 196, 0.1);
        border-radius: 50%;
        top: -150px;
        right: -150px;
        animation: float 25s infinite linear;
    }

    .shape-comment-2 {
        width: 200px;
        height: 200px;
        border: 3px solid rgba(255, 230, 109, 0.1);
        border-radius: 30px;
        bottom: 100px;
        left: -100px;
        transform: rotate(45deg);
        animation: float 20s infinite linear reverse;
    }

    /* Основной контейнер */
    .comment-card {
        background: white;
        border-radius: 30px;
        box-shadow: 0 30px 60px rgba(0, 0, 0, 0.15);
        overflow: hidden;
        display: grid;
        grid-template-columns: 1fr 1fr;
        min-height: 600px;
    }

    /* Левая панель с информацией */
    .comment-info-panel {
        background: linear-gradient(135deg, var(--dark-green) 0%, #2a7a87 100%);
        padding: 60px 50px;
        color: white;
        position: relative;
        overflow: hidden;
        display: flex;
        flex-direction: column;
    }

    .comment-info-panel::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('https://images.unsplash.com/photo-1501555088652-021faa106b9b?w=800&fit=crop&auto=format') center/cover;
        opacity: 0.1;
    }

    .comment-info-header {
        position: relative;
        z-index: 1;
        margin-bottom: 40px;
    }

    .comment-info-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 20px;
        line-height: 1.2;
    }

    .comment-info-subtitle {
        font-size: 1.2rem;
        opacity: 0.9;
        line-height: 1.6;
    }

    /* Цитаты */
    .quotes-section {
        position: relative;
        z-index: 1;
        flex: 1;
    }

    .quote-item {
        margin-bottom: 35px;
        padding: 25px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 20px;
        border-left: 4px solid var(--mint);
        transition: all 0.3s ease;
    }

    .quote-item:hover {
        background: rgba(255, 255, 255, 0.15);
        transform: translateY(-5px);
    }

    .quote-text {
        font-style: italic;
        font-size: 1.1rem;
        line-height: 1.6;
        margin-bottom: 15px;
        color: rgba(255, 255, 255, 0.95);
    }

    .quote-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .author-avatar {
        width: 40px;
        height: 40px;
        background: linear-gradient(45deg, var(--mint), var(--yellow));
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 1.1rem;
    }

    .author-info h5 {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 3px;
    }

    .author-info p {
        font-size: 0.9rem;
        opacity: 0.8;
        margin: 0;
    }

    /* Статистика */
    .stats-section {
        position: relative;
        z-index: 1;
        margin-top: auto;
        padding-top: 40px;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
    }

    .stat-item {
        text-align: center;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 5px;
        color: var(--yellow);
    }

    .stat-label {
        font-size: 0.9rem;
        opacity: 0.8;
    }

    /* Правая панель с формой */
    .comment-form-panel {
        padding: 60px 50px;
        display: flex;
        flex-direction: column;
    }

    .comment-form-header {
        margin-bottom: 40px;
        text-align: center;
    }

    .comment-form-logo {
        width: 80px;
        height: 80px;
        background: linear-gradient(45deg, var(--mint), var(--coral));
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 25px;
        color: white;
        font-size: 2rem;
        box-shadow: 0 10px 20px rgba(78, 205, 196, 0.3);
    }

    .comment-form-title {
        font-size: 2.2rem;
        color: var(--dark-green);
        font-weight: 700;
        margin-bottom: 10px;
    }

    .comment-form-subtitle {
        color: var(--gray);
        font-size: 1.1rem;
        line-height: 1.6;
    }

    /* Кастомные поля формы */
    .custom-form .form-group {
        margin-bottom: 35px;
        position: relative;
    }

    .custom-form label {
        display: block;
        margin-bottom: 12px;
        color: var(--dark-green);
        font-weight: 600;
        font-size: 1.1rem;
        letter-spacing: 0.3px;
    }

    .custom-form .form-select {
        width: 100%;
        padding: 18px 25px;
        border: 2px solid var(--border-color);
        border-radius: 15px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
        color: var(--dark);
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%231a535c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        background-size: 16px 12px;
    }

    .custom-form .form-select:focus {
        border-color: var(--mint);
        box-shadow: 0 5px 15px rgba(78, 205, 196, 0.15);
        outline: none;
    }

    .custom-form textarea {
        width: 100%;
        padding: 20px 25px;
        border: 2px solid var(--border-color);
        border-radius: 15px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
        color: var(--dark);
        resize: vertical;
        min-height: 180px;
        line-height: 1.6;
        font-family: inherit;
    }

    .custom-form textarea:focus {
        border-color: var(--mint);
        box-shadow: 0 5px 15px rgba(78, 205, 196, 0.15);
        outline: none;
    }

    .custom-form textarea::placeholder {
        color: #a8b5c0;
    }

    /* Контейнер для текстового поля с счетчиком */
    .textarea-container {
        position: relative;
    }

    .textarea-counter {
        position: absolute;
        bottom: 15px;
        right: 20px;
        color: var(--gray);
        font-size: 0.9rem;
        background: white;
        padding: 4px 12px;
        border-radius: 15px;
        transition: all 0.3s ease;
    }

    /* Предварительный просмотр тура */
    .tour-preview-container {
        margin-top: 15px;
        padding: 25px;
        background: rgba(78, 205, 196, 0.05);
        border-radius: 20px;
        border: 1px solid rgba(78, 205, 196, 0.2);
        display: none;
        animation: fadeIn 0.4s ease;
    }

    .tour-preview-container.active {
        display: block;
    }

    .preview-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 15px;
    }

    .preview-title {
        font-size: 1.3rem;
        color: var(--dark-green);
        font-weight: 600;
        line-height: 1.3;
    }

    .preview-price {
        background: linear-gradient(45deg, var(--mint), var(--coral));
        color: white;
        padding: 8px 16px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        white-space: nowrap;
    }

    .preview-details {
        display: flex;
        gap: 25px;
        color: var(--gray);
        font-size: 0.95rem;
    }

    .detail-item {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .detail-item i {
        color: var(--mint);
        font-size: 1rem;
    }

    /* Кнопка отправки */
    .submit-comment-button {
        width: 100%;
        padding: 20px;
        background: linear-gradient(45deg, var(--coral), #ff8e8e);
        color: white;
        border: none;
        border-radius: 15px;
        font-size: 1.2rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
        margin-top: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
    }

    .submit-comment-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, var(--mint), #6ce6dd);
        transition: left 0.5s ease;
        z-index: 1;
    }

    .submit-comment-button:hover::before {
        left: 0;
    }

    .submit-comment-button span {
        position: relative;
        z-index: 2;
    }

    .submit-comment-button:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(255, 107, 107, 0.3);
    }

    /* Подсказки для комментария */
    .comment-tips {
        margin-top: 25px;
        padding: 20px;
        background: rgba(255, 230, 109, 0.05);
        border-radius: 15px;
        border: 1px solid rgba(255, 230, 109, 0.2);
    }

    .tips-title {
        font-size: 1.1rem;
        color: var(--dark-green);
        font-weight: 600;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .tips-title i {
        color: var(--yellow);
    }

    .tips-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .tips-list li {
        color: var(--gray);
        margin-bottom: 10px;
        font-size: 0.95rem;
        line-height: 1.5;
        padding-left: 25px;
        position: relative;
    }

    .tips-list li::before {
        content: '✓';
        position: absolute;
        left: 0;
        color: var(--mint);
        font-weight: bold;
    }

    /* Анимации */
    @keyframes float {
        0% { transform: translate(0, 0) rotate(0deg); }
        33% { transform: translate(30px, -30px) rotate(120deg); }
        66% { transform: translate(-20px, 20px) rotate(240deg); }
        100% { transform: translate(0, 0) rotate(360deg); }
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Адаптивность */
    @media (max-width: 992px) {
        .comment-card {
            grid-template-columns: 1fr;
            max-width: 700px;
            margin: 0 auto;
        }

        .comment-info-panel {
            padding: 50px 40px;
            min-height: 400px;
        }

        .comment-form-panel {
            padding: 50px 40px;
        }

        .quotes-section {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
        }

        .quote-item {
            margin-bottom: 0;
        }

        .shape-comment-1,
        .shape-comment-2 {
            display: none;
        }
    }

    @media (max-width: 768px) {
        .comment-container {
            padding: 0 20px;
        }

        .comment-form-title {
            font-size: 1.8rem;
        }

        .comment-info-title {
            font-size: 2rem;
        }

        .stats-grid {
            grid-template-columns: 1fr;
            gap: 15px;
        }

        .stat-item {
            text-align: left;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .stat-number {
            font-size: 1.8rem;
            margin-bottom: 0;
        }
    }

    @media (max-width: 576px) {
        .comment-form-panel {
            padding: 40px 30px;
        }

        .comment-info-panel {
            padding: 40px 30px;
        }

        .comment-form-logo {
            width: 60px;
            height: 60px;
            font-size: 1.5rem;
        }

        .submit-comment-button {
            padding: 18px;
            font-size: 1.1rem;
        }

        .preview-details {
            flex-direction: column;
            gap: 10px;
        }
    }
</style>

<div class="comment-page">
    <div class="comment-shapes">
        <div class="shape-comment-1"></div>
        <div class="shape-comment-2"></div>
    </div>

    <div class="comment-container">
        <div class="comment-card">
            <!-- Левая панель с информацией -->
            <div class="comment-info-panel">
                <div class="comment-info-header">
                    <h2 class="comment-info-title">Поделитесь впечатлениями</h2>
                    <p class="comment-info-subtitle">Ваш отзыв поможет другим путешественникам сделать правильный выбор и улучшит наш сервис</p>
                </div>

                <div class="quotes-section">
                    <div class="quote-item">
                        <p class="quote-text">"Незабываемое путешествие! Организация на высшем уровне, гиды - профессионалы своего дела. Обязательно вернемся снова!"</p>
                        <div class="quote-author">
                            <div class="author-avatar">АИ</div>
                            <div class="author-info">
                                <h5>Анна Иванова</h5>
                                <p>Тур "Горные вершины Алтая"</p>
                            </div>
                        </div>
                    </div>

                    <div class="quote-item">
                        <p class="quote-text">"Всё прошло идеально! От трансфера до экскурсий - каждая деталь была продумана. Спасибо за незабываемые эмоции!"</p>
                        <div class="quote-author">
                            <div class="author-avatar">ПС</div>
                            <div class="author-info">
                                <h5>Павел Смирнов</h5>
                                <p>Тур "Пляжи Бали"</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="stats-section">
                    <div class="stats-grid">
                        <div class="stat-item">
                            <div class="stat-number">2,548</div>
                            <div class="stat-label">отзывов</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">4.8</div>
                            <div class="stat-label">средний рейтинг</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">98%</div>
                            <div class="stat-label">рекомендуют</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Правая панель с формой -->
            <div class="comment-form-panel">
                <div class="comment-form-header">
                    <div class="comment-form-logo">
                        <i class="fas fa-comment-alt"></i>
                    </div>
                    <h2 class="comment-form-title">Написать отзыв</h2>
                    <p class="comment-form-subtitle">Расскажите о вашем опыте путешествия с нами</p>
                </div>

                <?php $form = ActiveForm::begin([
                    'id' => 'comment-form',
                    'options' => ['class' => 'custom-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'errorOptions' => ['class' => 'invalid-feedback'],
                    ],
                ]); ?>

                <!-- Выбор тура -->
                <div class="form-group">
                    <?= $form->field($model, 'tour_id', [
                        'options' => ['class' => 'mb-4'],
                        'inputOptions' => [
                            'class' => 'form-select',
                            'id' => 'tourSelect'
                        ]
                    ])->dropDownList(
                        $tours,
                        ['prompt' => 'Выберите тур, о котором хотите оставить отзыв...']
                    )->label('Тур для отзыва') ?>

                    <div class="tour-preview-container" id="tourPreview">
                        <div class="preview-header">
                            <h3 class="preview-title" id="previewTitle"></h3>
                            <div class="preview-price" id="previewPrice"></div>
                        </div>
                        <div class="preview-details">
                            <div class="detail-item" id="previewDates">
                                <i class="far fa-calendar-alt"></i>
                                <span>Даты</span>
                            </div>
                            <div class="detail-item" id="previewDuration">
                                <i class="fas fa-clock"></i>
                                <span>Длительность</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Текст комментария -->
                <div class="form-group">
                    <div class="textarea-container">
                        <?= $form->field($model, 'text', [
                            'options' => ['tag' => false],
                            'inputOptions' => [
                                'class' => 'form-control',
                                'id' => 'commentText',
                                'placeholder' => 'Расскажите о вашем опыте: что понравилось, что можно улучшить, какие были впечатления от гида, отеля, экскурсий...'
                            ]
                        ])->textarea(['rows' => 6])->label('Ваш отзыв') ?>
                        <div class="textarea-counter">
                            <span id="charCount">0</span>/2000
                        </div>
                    </div>

                    <div class="comment-tips">
                        <h4 class="tips-title">
                            <i class="fas fa-lightbulb"></i>
                            Советы для хорошего отзыва:
                        </h4>
                        <ul class="tips-list">
                            <li>Опишите ваши основные впечатления от путешествия</li>
                            <li>Расскажите об организации тура и работе гидов</li>
                            <li>Поделитесь самыми запоминающимися моментами</li>
                            <li>Укажите, что можно было бы улучшить</li>
                            <li>Добавьте рекомендации для будущих путешественников</li>
                        </ul>
                    </div>
                </div>

                <!-- Кнопка отправки -->
                <button type="submit" class="submit-comment-button">
                    <i class="fas fa-paper-plane"></i>
                    <span>Опубликовать отзыв</span>
                </button>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Данные туров для предпросмотра (в реальном проекте это будет AJAX запрос)
        // Создаем mock данные на основе доступных туров
        const toursData = <?= json_encode(array_column($tours, 'title', 'id')) ?>;
        const toursPrices = <?= json_encode(array_column($tours, 'price', 'id')) ?>;
        const toursDates = <?= json_encode(array_column($tours, 'dates', 'id')) ?>;
        const toursDuration = <?= json_encode(array_column($tours, 'duration', 'id')) ?>;

        // Элементы DOM
        const tourSelect = document.getElementById('tourSelect');
        const tourPreview = document.getElementById('tourPreview');
        const previewTitle = document.getElementById('previewTitle');
        const previewPrice = document.getElementById('previewPrice');
        const previewDates = document.getElementById('previewDates');
        const previewDuration = document.getElementById('previewDuration');

        const commentText = document.getElementById('commentText');
        const charCount = document.getElementById('charCount');

        // Инициализация
        function initForm() {
            updateTourPreview();
            setupCharCounter();
            setupFormValidation();
            setupAnimations();
        }

        // Обновление предпросмотра тура
        function updateTourPreview() {
            const selectedTourId = tourSelect.value;

            if (selectedTourId && toursData[selectedTourId]) {
                const price = toursPrices[selectedTourId] || 0;
                const duration = toursDuration[selectedTourId] || '7 дней';
                const dates = toursDates[selectedTourId] || 'Гибкие даты';

                previewTitle.textContent = toursData[selectedTourId];
                previewPrice.textContent = formatPrice(price) + ' ₽';
                previewDates.innerHTML = `<i class="far fa-calendar-alt"></i><span>${dates}</span>`;
                previewDuration.innerHTML = `<i class="fas fa-clock"></i><span>${duration}</span>`;

                tourPreview.classList.add('active');
            } else {
                tourPreview.classList.remove('active');
            }
        }

        // Форматирование цены
        function formatPrice(price) {
            return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
        }

        // Счетчик символов
        function setupCharCounter() {
            function updateCharCount() {
                const length = commentText.value.length;
                charCount.textContent = length;

                if (length > 2000) {
                    charCount.style.color = 'var(--coral)';
                    charCount.style.fontWeight = 'bold';
                    commentText.style.borderColor = 'var(--coral)';
                } else if (length > 1500) {
                    charCount.style.color = 'var(--yellow)';
                    charCount.style.fontWeight = '600';
                    commentText.style.borderColor = 'var(--yellow)';
                } else if (length > 100) {
                    charCount.style.color = 'var(--mint)';
                    charCount.style.fontWeight = 'normal';
                    commentText.style.borderColor = 'var(--mint)';
                } else {
                    charCount.style.color = 'var(--gray)';
                    charCount.style.fontWeight = 'normal';
                    commentText.style.borderColor = '';
                }
            }

            commentText.addEventListener('input', updateCharCount);
            updateCharCount();
        }

        // Валидация формы
        function setupFormValidation() {
            const commentForm = document.getElementById('comment-form');

            if (commentForm) {
                commentForm.addEventListener('submit', function(e) {
                    let isValid = true;

                    // Проверка выбора тура
                    if (!tourSelect.value) {
                        showError(tourSelect, 'Пожалуйста, выберите тур для отзыва');
                        isValid = false;
                    }

                    // Проверка текста комментария
                    if (!commentText.value.trim()) {
                        showError(commentText, 'Пожалуйста, напишите ваш отзыв');
                        isValid = false;
                    } else if (commentText.value.length < 50) {
                        showError(commentText, 'Отзыв должен содержать не менее 50 символов');
                        isValid = false;
                    } else if (commentText.value.length > 2000) {
                        showError(commentText, 'Отзыв не должен превышать 2000 символов');
                        isValid = false;
                    }

                    if (!isValid) {
                        e.preventDefault();

                        // Анимация ошибки
                        const errorElements = document.querySelectorAll('.is-invalid');
                        errorElements.forEach(el => {
                            el.style.animation = 'none';
                            setTimeout(() => {
                                el.style.animation = 'fadeIn 0.5s ease';
                            }, 10);
                        });
                    } else {
                        // Анимация отправки
                        const submitButton = this.querySelector('.submit-comment-button');
                        if (submitButton) {
                            submitButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>Публикация...</span>';
                            submitButton.disabled = true;
                        }
                    }
                });
            }
        }

        // Функция показа ошибки
        function showError(input, message) {
            const formGroup = input.closest('.form-group');
            let errorDiv = formGroup.querySelector('.invalid-feedback');

            if (!errorDiv) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'invalid-feedback';
                formGroup.appendChild(errorDiv);
            }

            errorDiv.textContent = message;
            input.classList.add('is-invalid');
            errorDiv.style.display = 'block';
        }

        // Очистка ошибок при фокусе
        const inputs = [tourSelect, commentText];
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.classList.remove('is-invalid');
                const formGroup = this.closest('.form-group');
                if (formGroup) {
                    const errorDiv = formGroup.querySelector('.invalid-feedback');
                    if (errorDiv) {
                        errorDiv.style.display = 'none';
                    }
                }
            });
        });

        // Анимации при загрузке
        function setupAnimations() {
            setTimeout(() => {
                const formGroups = document.querySelectorAll('.form-group');
                formGroups.forEach((group, index) => {
                    group.style.opacity = '0';
                    group.style.transform = 'translateY(20px)';

                    setTimeout(() => {
                        group.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                        group.style.opacity = '1';
                        group.style.transform = 'translateY(0)';
                    }, 100 + index * 200);
                });

                // Анимация цитат
                const quoteItems = document.querySelectorAll('.quote-item');
                quoteItems.forEach((item, index) => {
                    item.style.opacity = '0';
                    item.style.transform = 'translateX(-20px)';

                    setTimeout(() => {
                        item.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                        item.style.opacity = '1';
                        item.style.transform = 'translateX(0)';
                    }, 300 + index * 200);
                });
            }, 300);
        }

        // Эффект для статистики
        function animateStats() {
            const statNumbers = document.querySelectorAll('.stat-number');
            statNumbers.forEach(stat => {
                const finalValue = parseInt(stat.textContent);
                let currentValue = 0;
                const increment = finalValue / 50;
                const timer = setInterval(() => {
                    currentValue += increment;
                    if (currentValue >= finalValue) {
                        stat.textContent = finalValue;
                        clearInterval(timer);
                    } else {
                        stat.textContent = Math.floor(currentValue);
                    }
                }, 30);
            });
        }

        // Запуск анимации статистики при скролле
        let statsAnimated = false;

        function checkStatsVisibility() {
            const statsSection = document.querySelector('.stats-section');
            if (statsSection && !statsAnimated) {
                const rect = statsSection.getBoundingClientRect();
                if (rect.top < window.innerHeight - 100) {
                    animateStats();
                    statsAnimated = true;
                }
            }
        }

        window.addEventListener('scroll', checkStatsVisibility);

        // Обработчики событий
        tourSelect.addEventListener('change', updateTourPreview);

        // Инициализация формы
        initForm();

        // Проверка видимости статистики при загрузке
        setTimeout(checkStatsVisibility, 500);

        // Интерактивные подсказки
        const tipsItems = document.querySelectorAll('.tips-list li');
        tipsItems.forEach((tip, index) => {
            tip.style.opacity = '0.7';
            tip.style.transform = 'translateX(-10px)';

            setTimeout(() => {
                tip.style.transition = 'all 0.3s ease';
                tip.style.opacity = '1';
                tip.style.transform = 'translateX(0)';
            }, 800 + index * 100);

            tip.addEventListener('mouseenter', function() {
                this.style.transform = 'translateX(5px)';
                this.style.background = 'rgba(78, 205, 196, 0.05)';
                this.style.paddingLeft = '30px';
            });

            tip.addEventListener('mouseleave', function() {
                this.style.transform = 'translateX(0)';
                this.style.background = 'transparent';
                this.style.paddingLeft = '25px';
            });
        });
    });
</script>