<?php
$this->title = 'Мои заявки';
use yii\helpers\Html;
use yii\helpers\Url;
?>

<?php $this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
<?php $this->registerCssFile('https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&display=swap') ?>

<style>
:root {
    --bg: #fcfdfd;
    --surface: #ffffff;
    --text: #2a2f3a;
    --text-light: #6c757d;
    --primary: #4ecdc4;
    --primary-light: #b0e5e1;
    --accent: #ffd166;
    --danger: #ff6b6b;
    --shadow-sm: 0 4px 12px rgba(0,0,0,0.03);
    --shadow-md: 0 8px 24px rgba(0,0,0,0.05);
    --radius: 20px;
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Manrope', sans-serif;
    background-color: var(--bg);
    color: var(--text);
}

.applications-page {
    min-height: calc(100vh - 160px);
    padding: 60px 0;
}

.applications-container {
    max-width: 1300px;
    margin: 0 auto;
    padding: 0 30px;
}

/* Header */
.applications-header {
    text-align: center;
    margin-bottom: 50px;
}

.applications-title {
    font-size: 2.8rem;
    font-weight: 700;
    margin-bottom: 16px;
    background: linear-gradient(135deg, var(--text), var(--primary));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    display: inline-block;
}

.applications-subtitle {
    color: var(--text-light);
    font-size: 1.1rem;
    max-width: 600px;
    margin: 0 auto 30px;
    line-height: 1.6;
}

/* Controls & Stats */
.applications-controls {
    background: var(--surface);
    border-radius: var(--radius);
    padding: 28px;
    box-shadow: var(--shadow-sm);
    margin-bottom: 40px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.stats {
    display: flex;
    gap: 32px;
}

.stat {
    text-align: center;
}

.stat-number {
    font-size: 1.8rem;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
}

.stat-label {
    font-size: 0.9rem;
    color: var(--text-light);
}

.action-btn {
    padding: 12px 28px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 50px;
    font-weight: 600;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 10px;
    transition: var(--transition);
}

.action-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(78, 205, 196, 0.25);
}

/* Filters */
.applications-filters {
    display: flex;
    gap: 14px;
    margin-bottom: 40px;
    flex-wrap: wrap;
}

.filter-btn {
    padding: 10px 22px;
    background: white;
    border: 1px solid #e0e6eb;
    border-radius: 50px;
    color: var(--text-light);
    font-size: 0.9rem;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    gap: 8px;
    white-space: nowrap;
}

.filter-btn:hover,
.filter-btn.active {
    border-color: var(--primary);
    color: var(--primary);
}

/* Applications Grid */
.applications-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(360px, 1fr));
    gap: 32px;
}

.application-card {
    background: var(--surface);
    border-radius: var(--radius);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
    transition: var(--transition);
    height: 100%;
}

.application-card:hover {
    transform: translateY(-8px);
    box-shadow: var(--shadow-md);
}

.card-header {
    padding: 24px 28px 18px;
    position: relative;
    border-bottom: 1px solid #f0f2f5;
}

.status-badge {
    position: absolute;
    top: 24px;
    right: 28px;
    padding: 6px 16px;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-confirmed {
    background: rgba(78, 205, 196, 0.15);
    color: var(--primary);
}

.status-pending {
    background: rgba(255, 230, 109, 0.3);
    color: #e6b800;
}

.status-cancelled {
    background: rgba(255, 107, 107, 0.15);
    color: var(--danger);
}

.card-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 14px;
    padding-right: 100px;
    color: var(--text);
}

.card-meta {
    display: flex;
    gap: 20px;
    margin-top: 16px;
    padding-top: 16px;
    border-top: 1px solid #f0f2f5;
    font-size: 0.9rem;
    color: var(--text-light);
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 8px;
}

/* Body */
.card-body {
    padding: 24px 28px;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 18px;
}

.detail-label {
    color: var(--text-light);
    font-size: 0.95rem;
    font-weight: 500;
}

.detail-value {
    color: var(--text);
    font-weight: 600;
    font-size: 1rem;
}

.badge {
    padding: 6px 14px;
    border-radius: 50px;
    font-size: 0.85rem;
    font-weight: 600;
}

.badge-participants {
    background: var(--primary-light);
    color: var(--primary);
}

.badge-payment-cash {
    background: rgba(255, 230, 109, 0.3);
    color: #e6b800;
}

.badge-payment-card {
    background: var(--primary-light);
    color: var(--primary);
}

/* Additional info */
.additional-toggle {
    background: none;
    border: none;
    color: var(--primary);
    font-size: 0.95rem;
    font-weight: 500;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    margin-top: 16px;
    padding: 0;
    text-align: left;
}

.additional-info {
    margin-top: 16px;
    padding: 16px;
    background: #f8fafc;
    border-radius: 12px;
    border: 1px solid #eef2f6;
    display: none;
}

.additional-info.show {
    display: block;
}

/* Footer */
.card-footer {
    padding: 0 28px 28px;
    display: flex;
    gap: 14px;
}

.card-btn {
    flex: 1;
    padding: 12px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 0.95rem;
    text-align: center;
    text-decoration: none;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    transition: var(--transition);
}

.btn-primary {
    background: var(--primary);
    color: white;
    border: 2px solid var(--primary);
}

.btn-primary:hover {
    background: #3aada0;
    transform: translateY(-3px);
}

.btn-outline {
    background: white;
    color: var(--text);
    border: 2px solid #e0e6eb;
}

.btn-outline:hover {
    border-color: var(--primary);
    color: var(--primary);
}

.btn-success {
    background: rgba(78, 205, 196, 0.1);
    color: var(--primary);
    border: 2px solid rgba(78, 205, 196, 0.3);
}

.btn-disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

/* No applications */
.no-applications {
    background: var(--surface);
    border-radius: var(--radius);
    padding: 70px 40px;
    text-align: center;
    box-shadow: var(--shadow-sm);
    grid-column: 1 / -1;
}

.no-app-icon {
    width: 80px;
    height: 80px;
    background: var(--primary-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 24px;
    color: var(--primary);
    font-size: 2.2rem;
}

.no-app-title {
    font-size: 1.8rem;
    font-weight: 600;
    margin-bottom: 16px;
}

.no-app-text {
    color: var(--text-light);
    max-width: 500px;
    margin: 0 auto 30px;
}

.explore-btn {
    display: inline-block;
    padding: 14px 32px;
    background: var(--primary);
    color: white;
    border-radius: 50px;
    text-decoration: none;
    font-weight: 600;
    transition: var(--transition);
}

.explore-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(78, 205, 196, 0.25);
}

/* Responsive */
@media (max-width: 1100px) {
    .applications-grid { grid-template-columns: repeat(auto-fill, minmax(320px, 1fr)); }
}

@media (max-width: 992px) {
    .applications-controls {
        flex-direction: column;
        align-items: stretch;
        gap: 24px;
    }
    .stats { justify-content: space-around; }
    .action-btn { align-self: center; }
}

@media (max-width: 768px) {
    .applications-container { padding: 0 20px; }
    .applications-title { font-size: 2.2rem; }
    .applications-grid { grid-template-columns: 1fr; }
    .card-footer { flex-direction: column; }
    .applications-filters { justify-content: center; }
    .stats { flex-wrap: wrap; justify-content: center; gap: 20px; }
}

@media (max-width: 576px) {
    .applications-title { font-size: 1.8rem; }
    .card-header, .card-body, .card-footer { padding: 20px; }
    .card-title { font-size: 1.1rem; padding-right: 0; }
    .detail-row { flex-direction: column; align-items: flex-start; gap: 6px; }
}
</style>

<div class="applications-page">
    <div class="applications-container">
        <div class="applications-header">
            <h1 class="applications-title">Мои заявки</h1>
            <p class="applications-subtitle">
                Отслеживайте статус бронирований, управляйте заявками и оставляйте отзывы о путешествиях
            </p>
        </div>

        <?php if (empty($applications)): ?>
            <div class="no-applications">
                <div class="no-app-icon"><i class="fas fa-compass"></i></div>
                <h3 class="no-app-title">Заявок пока нет</h3>
                <p class="no-app-text">
                    У вас нет оформленных заявок. Самое время отправиться в новое приключение!
                </p>
                <a href="<?= Url::to(['catalog/index']) ?>" class="explore-btn">
                    <i class="fas fa-search"></i> Найти тур
                </a>
            </div>
        <?php else: ?>
            <!-- Controls -->
            <div class="applications-controls">
                <div class="stats">
                    <div class="stat">
                        <div class="stat-number"><?= count($applications) ?></div>
                        <div class="stat-label">Всего</div>
                    </div>
                    <div class="stat">
                        <div class="stat-number">
                            <?= count(array_filter($applications, fn($a) => $a->status == 'confirmed')) ?>
                        </div>
                        <div class="stat-label">Подтверждено</div>
                    </div>
                    <div class="stat">
                        <div class="stat-number">
                            <?= count(array_filter($applications, fn($a) => !empty($a->comments))) ?>
                        </div>
                        <div class="stat-label">С отзывами</div>
                    </div>
                </div>
                <a href="<?= Url::to(['application/comment']) ?>" class="action-btn">
                    <i class="fas fa-star"></i> Отзыв
                </a>
            </div>

            <!-- Filters -->
            <div class="applications-filters">
                <button class="filter-btn active" data-filter="all">
                    <i class="fas fa-layer-group"></i> Все
                </button>
                <button class="filter-btn" data-filter="confirmed">
                    <i class="fas fa-check-circle"></i> Подтверждено
                </button>
                <button class="filter-btn" data-filter="pending">
                    <i class="fas fa-clock"></i> Ожидает
                </button>
                <button class="filter-btn" data-filter="upcoming">
                    <i class="fas fa-calendar-plus"></i> Предстоит
                </button>
                <button class="filter-btn" data-filter="completed">
                    <i class="fas fa-flag-checkered"></i> Завершено
                </button>
            </div>

            <!-- Grid -->
            <div class="applications-grid">
                <?php foreach ($applications as $app):
                    $status = $app->status ?? 'pending';
                    $statusClass = match($status) {
                        'confirmed' => 'status-confirmed',
                        'cancelled' => 'status-cancelled',
                        default => 'status-pending'
                    };
                    $statusText = match($status) {
                        'confirmed' => 'Подтверждена',
                        'cancelled' => 'Отменена',
                        default => 'Ожидает'
                    };

                    $isCompleted = strtotime($app->date_end) < time();
                    $isUpcoming = strtotime($app->date_start) > time();
                    ?>
                    <div class="application-card"
                         data-status="<?= $status ?>"
                         data-upcoming="<?= $isUpcoming ? 'true' : 'false' ?>"
                         data-completed="<?= $isCompleted ? 'true' : 'false' ?>">

                        <div class="card-header">
                            <div class="status-badge <?= $statusClass ?>"><?= $statusText ?></div>
                            <h3 class="card-title"><?= Html::encode($app->tour->title) ?></h3>
                            <div class="card-meta">
                                <div class="meta-item">
                                    <i class="far fa-calendar"></i>
                                    <?= date('d.m.Y', strtotime($app->created_at)) ?>
                                </div>
                                <div class="meta-item">
                                    <i class="fas <?= $isCompleted ? 'fa-flag-checkered' : ($isUpcoming ? 'fa-calendar-plus' : 'fa-plane') ?>"></i>
                                    <?= $isCompleted ? 'Завершено' : ($isUpcoming ? 'Предстоит' : 'В процессе') ?>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="detail-row">
                                <span class="detail-label">Даты:</span>
                                <span class="detail-value">
                                    <?= Yii::$app->formatter->asDate($app->date_start) ?> –
                                    <?= Yii::$app->formatter->asDate($app->date_end) ?>
                                </span>
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">Участники:</span>
                                <span class="badge badge-participants">
                                    <i class="fas fa-users"></i> <?= $app->count ?>
                                </span>
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">Оплата:</span>
                                <span class="badge <?= $app->payment ? 'badge-payment-card' : 'badge-payment-cash' ?>">
                                    <?= $app->payment ? 'Картой' : 'Наличными' ?>
                                </span>
                            </div>

                            <?php if ($app->additional): ?>
                                <button class="additional-toggle" data-target="add<?= $app->id ?>">
                                    <i class="fas fa-chevron-down"></i> Подробности
                                </button>
                                <div class="additional-info" id="add<?= $app->id ?>">
                                    <p><?= Html::encode($app->additional) ?></p>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card-footer">
                            <a href="<?= Url::to(['catalog/view', 'id' => $app->tour->id]) ?>" class="card-btn btn-primary">
                                <i class="fas fa-eye"></i> Тур
                            </a>

                            <?php if ($isCompleted): ?>
                                <?php if (empty($app->comments)): ?>
                                    <a href="<?= Url::to(['application/comment', 'tour_id' => $app->tour->id]) ?>" class="card-btn btn-outline">
                                        <i class="fas fa-star"></i> Отзыв
                                    </a>
                                <?php else: ?>
                                    <button class="card-btn btn-success" disabled>
                                        <i class="fas fa-check"></i> Отзыв есть
                                    </button>
                                <?php endif; ?>
                            <?php else: ?>
                                <button class="card-btn btn-outline btn-disabled" disabled>
                                    <i class="fas fa-clock"></i> После поездки
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle additional info
    document.querySelectorAll('.additional-toggle').forEach(btn => {
        btn.addEventListener('click', function() {
            const targetId = this.dataset.target;
            const target = document.getElementById(targetId);
            const icon = this.querySelector('i');

            target.classList.toggle('show');
            if (target.classList.contains('show')) {
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
                this.style.color = '#ff6b6b';
            } else {
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
                this.style.color = '';
            }
        });
    });

    // Filters
    const filterBtns = document.querySelectorAll('.filter-btn');
    const cards = document.querySelectorAll('.application-card');

    filterBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            filterBtns.forEach(b => b.classList.remove('active'));
            btn.classList.add('active');

            const filter = btn.dataset.filter;

            cards.forEach(card => {
                let show = false;
                switch(filter) {
                    case 'all': show = true; break;
                    case 'confirmed': show = card.dataset.status === 'confirmed'; break;
                    case 'pending': show = card.dataset.status === 'pending'; break;
                    case 'upcoming': show = card.dataset.upcoming === 'true'; break;
                    case 'completed': show = card.dataset.completed === 'true'; break;
                }
                card.style.display = show ? 'block' : 'none';
            });
        });
    });

    // Animate cards on load
    cards.forEach((card, i) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        setTimeout(() => {
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            card.style.opacity = '1';
            card.style.transform = 'translateY(0)';
        }, 200 + i * 80);
    });
});
</script>