<?php

use app\models\Tour;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap5\ActiveForm;
use yii\widgets\DetailView;
use yii\widgets\ListView;
use yii\data\ActiveDataProvider;

?>

<div class="tour-view">
    <div class="row mb-5">
        <div class="col-md-8">
            <?php if ($tour->image): ?>
                <div class="tour-image mb-4">
                    <?= Html::img('@web/images/' . $tour->image, [
                        'class' => 'img-fluid rounded',
                        'alt' => $tour->title,
                        'style' => 'max-height: 500px; width: 100%; object-fit: cover;'
                    ]) ?>
                </div>
            <?php endif; ?>

            <h1 class="mb-3"><?= Html::encode($tour->title) ?></h1>

            <div class="tour-description mb-4">
                <p class="lead"><?= nl2br(Html::encode($tour->description)) ?></p>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm sticky-top" style="top: 20px;">
                <div class="card-body">
                    <h4 class="card-title mb-4">Информация о туре</h4>

                    <div class="tour-details mb-4">
                        <div class="detail-item mb-3">
                            <h5 class="text-muted">Цена</h5>
                            <h3 class="text-primary"><?= number_format($tour->price, 0, '', ' ') ?> руб.</h3>
                        </div>

                        <div class="detail-item mb-3">
                            <h5 class="text-muted">Даты проведения</h5>
                            <div class="d-flex justify-content-between">
                                <div>
                                    <strong>Начало:</strong><br>
                                    <?= Yii::$app->formatter->asDate($tour->date_start, 'long') ?>
                                </div>
                                <div>
                                    <strong>Окончание:</strong><br>
                                    <?= Yii::$app->formatter->asDate($tour->date_end, 'long') ?>
                                </div>
                            </div>
                        </div>

                        <div class="detail-item mb-3">
                            <h5 class="text-muted">Длительность</h5>
                            <?php
                            $start = new DateTime($tour->date_start);
                            $end = new DateTime($tour->date_end);
                            $interval = $start->diff($end);
                            $days = $interval->days + 1;
                            ?>
                            <h5><?= $days ?> <?= $this->context->pluralForm($days, ['день', 'дня', 'дней']) ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="comments-section">
                <h3 class="mb-4">
                    Комментарии
                    <span class="badge badge-secondary">
                        <?= count($tour->comments) ?>
                    </span>
                </h3>

                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title">Добавить комментарий</h5>

                        <?php $form = ActiveForm::begin([
                            'action' => ['view', 'id' => $tour->id],
                        ]); ?>

                        <?= $form->field($comment, 'text')->textarea([
                            'rows' => 4,
                            'placeholder' => 'Текст комментария...',
                            'required' => true
                        ])->label('Комментарий') ?>

                        <?= Html::hiddenInput('Comment[tour_id]', $tour->id) ?>

                        <div class="form-group">
                            <?= Html::submitButton('Добавить комментарий', [
                                'class' => 'btn btn-primary'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>

                <?php if (!empty($tour->comments)): ?>
                    <div class="comments-list">
                        <?php foreach ($tour->comments as $comment): ?>
                            <div class="card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="mb-0">
                                            <?php if ($comment->user): ?>
                                                <?= Html::encode($comment->user->getFullName()) ?>
                                            <?php else: ?>
                                                Гость
                                            <?php endif; ?>
                                        </h6>
                                    </div>
                                    <p class="card-text">
                                        <?= Html::encode($comment->text) ?>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        Пока нет комментариев. Будьте первым!
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
