<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
        <style>
            :root {
                --dark-green: #1a535c;
                --mint: #4ecdc4;
                --cream: #f7fff7;
                --coral: #ff6b6b;
                --yellow: #ffe66d;
                --dark: #292f36;
                --gray: #6c757d;
            }

            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }

            body {
                font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                background-color: var(--cream);
                color: var(--dark);
                line-height: 1.6;
                min-height: 100vh;
                display: flex;
                flex-direction: column;
            }

            /* Современная навигация */
            .navbar-modern {
                background: rgba(255, 255, 255, 0.95) !important;
                backdrop-filter: blur(10px);
                border-bottom: none !important;
                box-shadow: 0 4px 30px rgba(0, 0, 0, 0.08);
                padding: 0;
                position: fixed !important;
                top: 0;
                left: 0;
                right: 0;
                z-index: 1000;
            }

            .navbar-container {
                max-width: 1400px;
                margin: 0 auto;
                padding: 0 30px;
                width: 100%;
            }

            .navbar-brand-modern {
                font-size: 1.8rem;
                font-weight: 700;
                color: var(--dark-green) !important;
                text-decoration: none;
                padding: 25px 0;
                display: flex;
                align-items: center;
                gap: 12px;
                transition: all 0.3s ease;
            }

            .navbar-brand-modern:hover {
                color: var(--mint) !important;
                transform: translateY(-2px);
            }

            .brand-icon {
                width: 40px;
                height: 40px;
                background: linear-gradient(45deg, var(--mint), var(--coral));
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-size: 1.2rem;
                transition: transform 0.3s ease;
            }

            .navbar-brand-modern:hover .brand-icon {
                transform: rotate(15deg);
            }

            .nav-modern {
                align-items: center;
                gap: 5px;
            }

            .nav-link-modern {
                color: var(--dark) !important;
                font-weight: 500;
                padding: 15px 20px !important;
                margin: 0 5px;
                border-radius: 12px;
                transition: all 0.3s ease;
                position: relative;
                text-decoration: none;
            }

            .nav-link-modern::before {
                content: '';
                position: absolute;
                bottom: 8px;
                left: 50%;
                transform: translateX(-50%);
                width: 0;
                height: 3px;
                background: linear-gradient(45deg, var(--mint), var(--coral));
                border-radius: 2px;
                transition: width 0.3s ease;
            }

            .nav-link-modern:hover {
                color: var(--dark-green) !important;
                background: rgba(78, 205, 196, 0.1);
                transform: translateY(-2px);
            }

            .nav-link-modern:hover::before {
                width: 60%;
            }

            .nav-link-modern.active {
                color: var(--dark-green) !important;
                background: rgba(78, 205, 196, 0.15);
            }

            .nav-link-modern.active::before {
                width: 80%;
            }

            .nav-link-special {
                background: linear-gradient(45deg, var(--coral), #ff8e8e) !important;
                color: white !important;
                padding: 12px 25px !important;
                border-radius: 50px;
                margin-left: 15px;
                box-shadow: 0 5px 15px rgba(255, 107, 107, 0.3);
                transition: all 0.3s ease;
            }

            .nav-link-special:hover {
                transform: translateY(-3px) scale(1.05);
                box-shadow: 0 8px 25px rgba(255, 107, 107, 0.4);
                color: white !important;
            }

            .nav-link-special::before {
                display: none;
            }

            .nav-link-admin {
                color: var(--coral) !important;
                font-weight: 600;
                position: relative;
            }

            .nav-link-admin::after {
                content: '✦';
                position: absolute;
                top: -5px;
                right: -5px;
                color: var(--yellow);
                font-size: 0.8rem;
            }

            /* Мобильное меню */
            .navbar-toggler-modern {
                border: none;
                background: transparent;
                width: 40px;
                height: 40px;
                position: relative;
                cursor: pointer;
                display: none;
            }

            .hamburger {
                width: 30px;
                height: 20px;
                position: relative;
                margin: 0 auto;
            }

            .hamburger span {
                display: block;
                position: absolute;
                height: 3px;
                width: 100%;
                background: var(--dark-green);
                border-radius: 3px;
                opacity: 1;
                left: 0;
                transform: rotate(0deg);
                transition: .25s ease-in-out;
            }

            .hamburger span:nth-child(1) {
                top: 0px;
            }

            .hamburger span:nth-child(2) {
                top: 8px;
            }

            .hamburger span:nth-child(3) {
                top: 16px;
            }

            /* Основной контент */
            .main-content {
                flex: 1 0 auto;
                padding-top: 100px;
                min-height: calc(100vh - 200px);
            }

            .container-modern {
                max-width: 1400px;
                margin: 0 auto;
                padding: 0 30px;
                width: 100%;
            }

            /* Хлебные крошки */
            .breadcrumbs-modern {
                background: rgba(255, 255, 255, 0.8);
                backdrop-filter: blur(5px);
                border-radius: 15px;
                padding: 15px 25px;
                margin-bottom: 30px;
                border: 1px solid rgba(78, 205, 196, 0.2);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            }

            .breadcrumb {
                margin-bottom: 0;
                background: transparent;
            }

            .breadcrumb-item a {
                color: var(--mint);
                text-decoration: none;
                font-weight: 500;
                transition: color 0.3s ease;
            }

            .breadcrumb-item a:hover {
                color: var(--dark-green);
            }

            .breadcrumb-item.active {
                color: var(--dark);
                font-weight: 600;
            }

            .breadcrumb-item + .breadcrumb-item::before {
                color: var(--gray);
                content: "›";
                font-size: 1.2rem;
                line-height: 1;
            }

            /* Футер */
            .footer-modern {
                background: linear-gradient(135deg, var(--dark-green) 0%, #2a7a87 100%);
                color: white;
                padding: 60px 0 30px;
                margin-top: auto;
                flex-shrink: 0;
            }

            .footer-content {
                max-width: 1400px;
                margin: 0 auto;
                padding: 0 30px;
                display: flex;
                justify-content: space-between;
                align-items: center;
                flex-wrap: wrap;
                gap: 30px;
            }

            .footer-logo {
                font-size: 1.8rem;
                font-weight: 700;
                color: white;
                text-decoration: none;
                display: flex;
                align-items: center;
                gap: 12px;
            }

            .footer-logo-icon {
                width: 40px;
                height: 40px;
                background: linear-gradient(45deg, var(--yellow), var(--mint));
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                color: var(--dark-green);
                font-size: 1.2rem;
            }

            .footer-copyright {
                font-size: 0.95rem;
                opacity: 0.9;
                text-align: center;
                flex: 1;
            }

            .footer-social {
                display: flex;
                gap: 15px;
            }

            .social-link {
                width: 45px;
                height: 45px;
                background: rgba(255, 255, 255, 0.1);
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                text-decoration: none;
                font-size: 1.2rem;
                transition: all 0.3s ease;
            }

            .social-link:hover {
                background: rgba(255, 255, 255, 0.2);
                transform: translateY(-3px);
            }

            /* Алерты */
            .alert-modern {
                border: none;
                border-radius: 15px;
                padding: 20px 25px;
                margin-bottom: 30px;
                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
                position: relative;
                overflow: hidden;
            }

            .alert-modern::before {
                content: '';
                position: absolute;
                left: 0;
                top: 0;
                bottom: 0;
                width: 8px;
                background: currentColor;
                opacity: 0.3;
            }

            .alert-success {
                background: linear-gradient(135deg, rgba(78, 205, 196, 0.1) 0%, rgba(78, 205, 196, 0.05) 100%);
                border-left: 4px solid var(--mint);
                color: #155724;
            }

            .alert-danger {
                background: linear-gradient(135deg, rgba(255, 107, 107, 0.1) 0%, rgba(255, 107, 107, 0.05) 100%);
                border-left: 4px solid var(--coral);
                color: #721c24;
            }

            .alert-warning {
                background: linear-gradient(135deg, rgba(255, 230, 109, 0.1) 0%, rgba(255, 230, 109, 0.05) 100%);
                border-left: 4px solid var(--yellow);
                color: #856404;
            }

            .alert-info {
                background: linear-gradient(135deg, rgba(26, 83, 92, 0.1) 0%, rgba(26, 83, 92, 0.05) 100%);
                border-left: 4px solid var(--dark-green);
                color: #0c5460;
            }

            /* Адаптивность */
            @media (max-width: 992px) {
                .navbar-container {
                    padding: 0 20px;
                }

                .container-modern {
                    padding: 0 20px;
                }

                .navbar-collapse {
                    position: fixed;
                    top: 90px;
                    left: 0;
                    right: 0;
                    background: white;
                    padding: 30px;
                    border-radius: 0 0 20px 20px;
                    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
                    transform: translateY(-100%);
                    opacity: 0;
                    visibility: hidden;
                    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
                    z-index: 999;
                }

                .navbar-collapse.show {
                    transform: translateY(0);
                    opacity: 1;
                    visibility: visible;
                }

                .nav-modern {
                    flex-direction: column;
                    gap: 10px;
                    align-items: stretch;
                }

                .nav-link-modern {
                    margin: 5px 0;
                    padding: 15px 20px !important;
                    border-radius: 12px;
                    text-align: center;
                }

                .navbar-toggler-modern {
                    display: block;
                }

                .footer-content {
                    flex-direction: column;
                    text-align: center;
                    gap: 25px;
                }
            }

            @media (max-width: 768px) {
                .main-content {
                    padding-top: 90px;
                }

                .navbar-brand-modern {
                    font-size: 1.5rem;
                    padding: 20px 0;
                }

                .brand-icon {
                    width: 35px;
                    height: 35px;
                }
            }
        </style>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' => '<div class="brand-icon"><i class="fas fa-compass"></i></div><span>Горизонты</span>',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => [
                'class' => 'navbar navbar-expand-lg navbar-modern',
            ],
            'brandOptions' => [
                'class' => 'navbar-brand-modern'
            ],
            'containerOptions' => [
                'class' => 'navbar-container'
            ]
        ]);

        // Определяем активный пункт меню
        $currentRoute = Yii::$app->controller->route;
        $isActive = function($route) use ($currentRoute) {
            return strpos($currentRoute, $route) === 0 ? 'active' : '';
        };

        echo Nav::widget([
            'options' => [
                'class' => 'navbar-nav ms-auto nav-modern',
                'id' => 'main-nav'
            ],
            'items' => [
                [
                    'label' => 'Главная',
                    'url' => ['/site/index'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern ' . $isActive('site/index')
                    ]
                ],
                [
                    'label' => 'Каталог',
                    'url' => ['/catalog/index'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern ' . $isActive('catalog')
                    ]
                ],
                [
                    'label' => 'Оформить заявку',
                    'url' => ['/application/create'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern nav-link-special ' . $isActive('application/create')
                    ]
                ],
                [
                    'label' => 'Мои заявки',
                    'url' => ['/application/index'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern ' . $isActive('application/index')
                    ],
                    'visible' => !Yii::$app->user->isGuest
                ],
                Yii::$app->user->identity && Yii::$app->user->identity->is_admin
                    ? [
                    'label' => 'Админ',
                    'url' => ['/admin/index'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern nav-link-admin ' . $isActive('admin')
                    ]
                ]
                    : ['label' => ''],
                Yii::$app->user->isGuest
                    ? [
                    'label' => 'Войти',
                    'url' => ['/site/login'],
                    'linkOptions' => [
                        'class' => 'nav-link-modern ' . $isActive('site/login')
                    ]
                ]
                    : '<li class="nav-item">
                    <div class="nav-link-modern">
                        ' . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-inline'])
                    . Html::submitButton(
                        '<i class="fas fa-sign-out-alt me-2"></i>' . Html::encode(Yii::$app->user->identity->first_name),
                        [
                            'class' => 'btn btn-link p-0 border-0 text-decoration-none',
                            'style' => 'color: inherit; font-weight: inherit;'
                        ]
                    )
                    . Html::endForm() . '
                    </div>
                </li>'
            ],
            'encodeLabels' => false
        ]);

        // Кастомный тогглер для мобильного меню
        echo '<button class="navbar-toggler-modern" type="button" id="navbarToggle">
            <div class="hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
          </button>';

        NavBar::end();
        ?>
    </header>

    <main id="main" class="main-content" role="main">
        <div class="container-modern">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <nav class="breadcrumbs-modern" aria-label="breadcrumb">
                    <?= Breadcrumbs::widget([
                        'links' => $this->params['breadcrumbs'],
                        'options' => ['class' => 'breadcrumb'],
                        'itemTemplate' => '<li class="breadcrumb-item">{link}</li>',
                        'activeItemTemplate' => '<li class="breadcrumb-item active" aria-current="page">{link}</li>'
                    ]) ?>
                </nav>
            <?php endif ?>

            <?= Alert::widget([
                'options' => [
                    'class' => 'alert-modern'
                ]
            ]) ?>

            <?= $content ?>
        </div>
    </main>

    <footer id="footer" class="footer-modern">
        <div class="footer-content">
            <a href="<?= Yii::$app->homeUrl ?>" class="footer-logo">
                <div class="footer-logo-icon">
                    <i class="fas fa-compass"></i>
                </div>
                <span>Горизонты</span>
            </a>

            <div class="footer-copyright">
                <p>&copy; <?= date('Y') ?> Horizon Travel. Все права защищены.</p>
                <p style="opacity: 0.7; font-size: 0.9rem; margin-top: 5px;">Путешествия, которые меняют перспективу</p>
            </div>

            <div class="footer-social">
                <a href="#" class="social-link" title="Telegram">
                    <i class="fab fa-telegram"></i>
                </a>
                <a href="#" class="social-link" title="Instagram">
                    <i class="fab fa-instagram"></i>
                </a>
                <a href="#" class="social-link" title="VK">
                    <i class="fab fa-vk"></i>
                </a>
                <a href="#" class="social-link" title="YouTube">
                    <i class="fab fa-youtube"></i>
                </a>
            </div>
        </div>
    </footer>

    <script>
        // Мобильное меню
        document.addEventListener('DOMContentLoaded', function() {
            const navbarToggle = document.getElementById('navbarToggle');
            const navbarCollapse = document.querySelector('.navbar-collapse');
            const hamburger = navbarToggle.querySelector('.hamburger');

            if (navbarToggle) {
                navbarToggle.addEventListener('click', function() {
                    navbarCollapse.classList.toggle('show');
                    hamburger.classList.toggle('active');

                    // Анимация гамбургера
                    const spans = hamburger.querySelectorAll('span');
                    if (navbarCollapse.classList.contains('show')) {
                        spans[0].style.transform = 'rotate(45deg)';
                        spans[0].style.top = '8px';
                        spans[1].style.opacity = '0';
                        spans[2].style.transform = 'rotate(-45deg)';
                        spans[2].style.top = '8px';
                    } else {
                        spans[0].style.transform = 'rotate(0)';
                        spans[0].style.top = '0px';
                        spans[1].style.opacity = '1';
                        spans[2].style.transform = 'rotate(0)';
                        spans[2].style.top = '16px';
                    }
                });

                // Закрытие меню при клике на ссылку
                const navLinks = document.querySelectorAll('.nav-link-modern');
                navLinks.forEach(link => {
                    link.addEventListener('click', function() {
                        if (navbarCollapse.classList.contains('show')) {
                            navbarCollapse.classList.remove('show');
                            hamburger.classList.remove('active');

                            const spans = hamburger.querySelectorAll('span');
                            spans[0].style.transform = 'rotate(0)';
                            spans[0].style.top = '0px';
                            spans[1].style.opacity = '1';
                            spans[2].style.transform = 'rotate(0)';
                            spans[2].style.top = '16px';
                        }
                    });
                });
            }

            // Плавный скролл для якорных ссылок
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href !== '#') {
                        e.preventDefault();
                        const targetElement = document.querySelector(href);
                        if (targetElement) {
                            window.scrollTo({
                                top: targetElement.offsetTop - 100,
                                behavior: 'smooth'
                            });
                        }
                    }
                });
            });

            // Динамическое изменение прозрачности навигации при скролле
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-modern');
                if (window.scrollY > 50) {
                    navbar.style.background = 'rgba(255, 255, 255, 0.98)';
                    navbar.style.boxShadow = '0 4px 30px rgba(0, 0, 0, 0.1)';
                } else {
                    navbar.style.background = 'rgba(255, 255, 255, 0.95)';
                    navbar.style.boxShadow = '0 4px 30px rgba(0, 0, 0, 0.08)';
                }
            });
        });
    </script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>