<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Главная';
?>

<?php $this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
<?php $this->registerCssFile('https://fonts.googleapis.com/css2?family=Manrope:wght@300;400;500;600;700&display=swap') ?>

<style>
    :root {
        --bg: #fcfdfd;
        --surface: #ffffff;
        --text: #2a2f3a;
        --text-light: #6c757d;
        --primary: #4ecdc4;
        --primary-light: #b0e5e1;
        --accent: #ffd166;
        --shadow-sm: 0 4px 12px rgba(0,0,0,0.03);
        --shadow-md: 0 8px 24px rgba(0,0,0,0.05);
        --radius: 24px;
        --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Manrope', sans-serif;
        background-color: var(--bg);
        color: var(--text);
        line-height: 1.6;
        overflow-x: hidden;
    }

    /* ——— HERO ——— */
    .hero {
        padding: 120px 5% 100px;
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 60px;
        align-items: center;
        position: relative;
    }

    .hero::before {
        content: "";
        position: absolute;
        top: -100px;
        right: -100px;
        width: 400px;
        height: 400px;
        border-radius: 50%;
        background: var(--primary-light);
        opacity: 0.15;
        z-index: 0;
    }

    .hero-content {
        position: relative;
        z-index: 2;
    }

    .hero-title {
        font-size: 3.2rem;
        font-weight: 700;
        line-height: 1.1;
        margin-bottom: 1.2rem;
        background: linear-gradient(135deg, #2a2f3a, #4ecdc4);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .hero-subtitle {
        font-size: 1.15rem;
        color: var(--text-light);
        margin-bottom: 2.5rem;
        max-width: 500px;
    }

    .btn-neomorph {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 16px 36px;
        background: var(--surface);
        color: var(--text);
        font-weight: 600;
        font-size: 1.05rem;
        border-radius: var(--radius);
        text-decoration: none;
        box-shadow: var(--shadow-md);
        transition: var(--transition);
        position: relative;
        overflow: hidden;
    }

    .btn-neomorph::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: var(--primary);
        opacity: 0;
        transition: opacity 0.3s ease;
        z-index: -1;
    }

    .btn-neomorph:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 30px rgba(78, 205, 196, 0.15);
    }

    .btn-neomorph:hover::before {
        opacity: 0.1;
    }

    .hero-image {
        position: relative;
        border-radius: var(--radius);
        overflow: hidden;
        box-shadow: var(--shadow-md);
        aspect-ratio: 4/5;
        background: url('https://images.unsplash.com/photo-1501785888041-af3ef285b470?w=800&fit=crop') center/cover;
        z-index: 1;
    }

    /* ——— SECTION ——— */
    .section {
        padding: 100px 5%;
    }

    .section-header {
        text-align: center;
        max-width: 700px;
        margin: 0 auto 60px;
    }

    .section-tag {
        display: inline-block;
        background: var(--accent);
        color: var(--text);
        padding: 6px 20px;
        border-radius: 50px;
        font-size: 0.85rem;
        font-weight: 600;
        margin-bottom: 16px;
        letter-spacing: 0.5px;
    }

    .section-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 16px;
        color: var(--text);
    }

    .section-desc {
        color: var(--text-light);
        font-size: 1.05rem;
    }

    /* ——— FEATURES ——— */
    .features {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 32px;
        margin-top: 40px;
    }

    .feature-card {
        background: var(--surface);
        padding: 32px;
        border-radius: var(--radius);
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
        text-align: center;
    }

    .feature-card:hover {
        transform: translateY(-6px);
        box-shadow: var(--shadow-md);
    }

    .feature-icon {
        width: 72px;
        height: 72px;
        margin: 0 auto 20px;
        background: var(--primary-light);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        font-size: 1.8rem;
    }

    .feature-title {
        font-size: 1.35rem;
        font-weight: 600;
        margin-bottom: 12px;
    }

    .feature-text {
        color: var(--text-light);
        font-size: 0.95rem;
    }

    /* ——— TOURS ——— */
    .tours-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 40px;
        margin-top: 50px;
    }

    .tour-card {
        background: var(--surface);
        border-radius: var(--radius);
        overflow: hidden;
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
    }

    .tour-card:hover {
        transform: translateY(-8px);
        box-shadow: var(--shadow-md);
    }

    .tour-img {
        height: 220px;
        background-size: cover;
        background-position: center;
    }

    .tour-price {
        position: absolute;
        top: 16px;
        right: 16px;
        background: var(--accent);
        color: var(--text);
        padding: 6px 16px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.95rem;
    }

    .tour-content {
        padding: 24px;
    }

    .tour-title {
        font-size: 1.3rem;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .tour-desc {
        color: var(--text-light);
        font-size: 0.95rem;
        margin-bottom: 14px;
    }

    .tour-date {
        color: var(--primary);
        font-size: 0.9rem;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .btn-outline {
        display: inline-block;
        margin-top: 16px;
        padding: 10px 24px;
        color: var(--primary);
        border: 2px solid var(--primary);
        border-radius: 50px;
        font-weight: 600;
        font-size: 0.95rem;
        text-decoration: none;
        transition: var(--transition);
    }

    .btn-outline:hover {
        background: var(--primary);
        color: white;
    }

    /* ——— REVIEWS ——— */
    .reviews {
        display: flex;
        gap: 24px;
        overflow-x: auto;
        padding: 20px 0;
        scrollbar-width: none;
    }

    .reviews::-webkit-scrollbar {
        display: none;
    }

    .review-card {
        min-width: 300px;
        background: var(--surface);
        padding: 32px;
        border-radius: var(--radius);
        box-shadow: var(--shadow-sm);
        position: relative;
    }

    .review-card::before {
        content: """;
        position: absolute;
        top: 12px;
        left: 24px;
        font-size: 4rem;
        color: var(--primary-light);
        font-family: serif;
        line-height: 1;
        opacity: 0.3;
    }

    .review-text {
        color: var(--text-light);
        font-style: italic;
        margin-bottom: 20px;
        position: relative;
        z-index: 1;
    }

    .review-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .author-avatar {
        width: 44px;
        height: 44px;
        border-radius: 50%;
        background: var(--primary-light);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        font-weight: 600;
        font-size: 1.1rem;
    }

    .author-name {
        font-weight: 600;
        font-size: 1rem;
    }

    .author-tour {
        color: var(--text-light);
        font-size: 0.85rem;
    }

    /* ——— CONTACTS ——— */
    .contacts {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 32px;
        margin-top: 50px;
    }

    .contact-card {
        text-align: center;
        padding: 32px 24px;
        background: var(--surface);
        border-radius: var(--radius);
        box-shadow: var(--shadow-sm);
    }

    .contact-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 16px;
        background: var(--primary-light);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        font-size: 1.6rem;
    }

    .contact-title {
        font-weight: 600;
        margin-bottom: 10px;
    }

    .contact-text a {
        color: var(--text);
        text-decoration: none;
        transition: color 0.2s;
    }

    .contact-text a:hover {
        color: var(--primary);
    }

    /* ——— SCROLL TOP ——— */
    .scroll-top {
        position: fixed;
        bottom: 30px;
        right: 30px;
        width: 56px;
        height: 56px;
        background: var(--surface);
        color: var(--primary);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        cursor: pointer;
        opacity: 0;
        visibility: hidden;
        transition: var(--transition);
        box-shadow: var(--shadow-sm);
        z-index: 1000;
    }

    .scroll-top.visible {
        opacity: 1;
        visibility: visible;
    }

    .scroll-top:hover {
        background: var(--primary);
        color: white;
        transform: translateY(-4px);
    }

    /* ——— ADAPTIVE ——— */
    @media (max-width: 992px) {
        .hero {
            grid-template-columns: 1fr;
            text-align: center;
            gap: 50px;
        }
        .hero-content { text-align: center; }
        .hero-subtitle { margin: 0 auto 2.5rem; }
        .hero-image { margin: 0 auto; max-width: 400px; }
    }

    @media (max-width: 768px) {
        .hero-title { font-size: 2.4rem; }
        .section-title { font-size: 2rem; }
        .hero { padding: 90px 20px 70px; }
        .section { padding: 70px 20px; }
    }

    @media (max-width: 576px) {
        .hero-title { font-size: 2rem; }
        .btn-neomorph { width: 100%; justify-content: center; }
        .reviews { gap: 16px; }
        .review-card { min-width: 280px; }
    }
</style>

<!-- HERO -->
<section class="hero" id="home">
    <div class="hero-content">
        <h1 class="hero-title">Открываем мир по-новому</h1>
        <p class="hero-subtitle">Эксклюзивные маршруты, персонализированные путешествия и моменты, которые останутся с вами навсегда</p>
        <a href="#tours" class="btn-neomorph">
            <i class="fas fa-compass"></i> Исследовать туры
        </a>
    </div>
    <div class="hero-image"></div>
</section>

<!-- ABOUT -->
<section class="section" style="background: var(--surface);">
    <div class="section-header">
        <span class="section-tag">Наша философия</span>
        <h2 class="section-title">Не просто туры, а трансформация</h2>
        <p class="section-desc">Мы создаем путешествия, которые меняют восприятие мира, расширяют границы возможного и оставляют след в душе</p>
    </div>

    <div class="features">
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-compass"></i></div>
            <h3 class="feature-title">Интуитивные маршруты</h3>
            <p class="feature-text">Путешествия, построенные на глубоком понимании местной культуры и скрытых жемчужин</p>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-users"></i></div>
            <h3 class="feature-title">Мини-группы</h3>
            <p class="feature-text">Только небольшие группы до 8 человек для сохранения интимности и качества</p>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-leaf"></i></div>
            <h3 class="feature-title">Устойчивый туризм</h3>
            <p class="feature-text">Сотрудничаем только с локальными сообществами и эко-отелями</p>
        </div>
    </div>
</section>

<!-- TOURS -->
<section class="section" id="tours">
    <div class="section-header">
        <span class="section-tag">Коллекция</span>
        <h2 class="section-title">Избранные маршруты</h2>
        <p class="section-desc">Каждое путешествие — уникальная история, которую мы пишем вместе с вами</p>
    </div>

    <div class="tours-grid">
        <?php foreach ($tours as $tour): ?>
            <div class="tour-card">
                <div class="tour-img" style="background-image: url('<?= $tour->image ? Yii::getAlias('@web/images/') . $tour->image : 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800&fit=crop' ?>')">
                    <div class="tour-price"><?= number_format($tour->price, 0, '', ' ') ?> ₽</div>
                </div>
                <div class="tour-content">
                    <h3 class="tour-title"><?= Html::encode($tour->title) ?></h3>
                    <p class="tour-desc">
                        <?= mb_strlen($tour->description) > 120 ? mb_substr($tour->description, 0, 120) . '...' : $tour->description ?>
                    </p>
                    <div class="tour-date">
                        <i class="far fa-calendar"></i>
                        <?= date('d.m.Y', strtotime($tour->date_start)) ?> — <?= date('d.m.Y', strtotime($tour->date_end)) ?>
                    </div>
                    <a href="<?= Url::to(['catalog/view', 'id' => $tour->id]) ?>" class="btn-outline">Подробнее</a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div style="text-align: center; margin-top: 50px;">
        <a href="<?= Url::to(['catalog/index']) ?>" class="btn-neomorph">
            <i class="fas fa-globe"></i> Все направления
        </a>
    </div>
</section>

<!-- SERVICES -->
<section class="section" style="background: var(--surface);">
    <div class="section-header">
        <span class="section-tag">Детали</span>
        <h2 class="section-title">Дополнительные опции</h2>
        <p class="section-desc">Персонализируйте свое путешествие с нами</p>
    </div>

    <div class="features">
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-camera"></i></div>
            <h3 class="feature-title">Фотопутешествие</h3>
            <p class="feature-text">Профессиональный фотограф сопроводит ваше приключение</p>
            <div style="margin-top: 16px; color: var(--primary); font-weight: 600;">от 5000 ₽/день</div>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-utensils"></i></div>
            <h3 class="feature-title">Гастрономические туры</h3>
            <p class="feature-text">Дегустации и кулинарные мастер-классы от локальных шефов</p>
            <div style="margin-top: 16px; color: var(--primary); font-weight: 600;">от 3500 ₽</div>
        </div>
        <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-spa"></i></div>
            <h3 class="feature-title">Велнес-ретриты</h3>
            <p class="feature-text">Йога, медитации и спа в живописных локациях</p>
            <div style="margin-top: 16px; color: var(--primary); font-weight: 600;">от 8000 ₽</div>
        </div>
    </div>
</section>

<!-- REVIEWS -->
<section class="section" style="background: linear-gradient(135deg, #eef7f6, #f8fdfc);">
    <div class="section-header">
        <span class="section-tag" style="background: var(--accent);">Истории</span>
        <h2 class="section-title">Их путешествия</h2>
        <p class="section-desc">Реальные впечатления наших путешественников</p>
    </div>

    <div class="reviews">
        <?php if (!empty($comments)): ?>
            <?php foreach ($comments as $comment): ?>
                <div class="review-card">
                    <p class="review-text"><?= Html::encode($comment->text) ?></p>
                    <div class="review-author">
                        <div class="author-avatar">
                            <?= mb_substr($comment->user && $comment->user->getFullName() ? $comment->user->getFullName() : 'Г', 0, 1) ?>
                        </div>
                        <div>
                            <div class="author-name">
                                <?= $comment->user ? Html::encode($comment->user->getFullName()) : 'Гость' ?>
                            </div>
                            <?php if ($comment->tour): ?>
                                <div class="author-tour"><?= Html::encode($comment->tour->title) ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="review-card">
                <p class="review-text">Будьте первым, кто поделится впечатлениями о путешествии с нами!</p>
                <div class="review-author">
                    <div class="author-avatar">?</div>
                    <div>
                        <div class="author-name">Ваша история здесь</div>
                        <div class="author-tour">Станьте частью сообщества</div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- CONTACTS -->
<section class="section">
    <div class="section-header">
        <span class="section-tag">Связь</span>
        <h2 class="section-title">Начнем диалог</h2>
        <p class="section-desc">Готовы спланировать ваше идеальное путешествие? Давайте обсудим детали</p>
    </div>

    <div class="contacts">
        <div class="contact-card">
            <div class="contact-icon"><i class="fas fa-map-marker-alt"></i></div>
            <h4 class="contact-title">Приходите к нам</h4>
            <div class="contact-text">
                г. Москва, ул. Творческая, д. 42<br>
                Лофт "Горизонты"
            </div>
        </div>
        <div class="contact-card">
            <div class="contact-icon"><i class="fas fa-phone"></i></div>
            <h4 class="contact-title">Позвоните нам</h4>
            <div class="contact-text">
                <a href="tel:+79999999999">+7 (999) 999-99-99</a><br>
                Ежедневно с 10:00 до 22:00
            </div>
        </div>
        <div class="contact-card">
            <div class="contact-icon"><i class="fas fa-envelope"></i></div>
            <h4 class="contact-title">Напишите нам</h4>
            <div class="contact-text">
                <a href="mailto:mail@mail.ru">mail@mail.ru</a><br>
                Отвечаем в течение 2 часов
            </div>
        </div>
    </div>
</section>

<!-- SCROLL TOP -->
<div class="scroll-top" id="scrollTop">
    <i class="fas fa-arrow-up"></i>
</div>

<script>
    document.getElementById('scrollTop').addEventListener('click', () => {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

    window.addEventListener('scroll', () => {
        const btn = document.getElementById('scrollTop');
        if (window.scrollY > 600) {
            btn.classList.add('visible');
        } else {
            btn.classList.remove('visible');
        }
    });
</script>