<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    :root {
        --dark-green: #1a535c;
        --mint: #4ecdc4;
        --cream: #f7fff7;
        --coral: #ff6b6b;
        --yellow: #ffe66d;
        --dark: #292f36;
        --gray: #6c757d;
        --light-gray: #e8f4f8;
    }

    .login-page {
        min-height: calc(100vh - 200px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
        position: relative;
        overflow: hidden;
    }

    .login-container {
        display: flex;
        max-width: 1200px;
        width: 100%;
        min-height: 700px;
        background: white;
        border-radius: 30px;
        overflow: hidden;
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
        position: relative;
    }

    /* Левая панель с графикой */
    .login-hero {
        flex: 1;
        background: linear-gradient(135deg, var(--dark-green) 0%, #2a7a87 100%);
        padding: 60px 50px;
        color: white;
        position: relative;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .login-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('https://images.unsplash.com/photo-1507525428034-b723cf961d3e?w=800&fit=crop&auto=format') center/cover;
        opacity: 0.15;
    }

    .login-title {
        font-size: 2.8rem;
        font-weight: 700;
        margin-bottom: 20px;
        line-height: 1.2;
        position: relative;
        z-index: 1;
    }

    .login-subtitle {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 40px;
        line-height: 1.6;
        position: relative;
        z-index: 1;
        max-width: 400px;
    }

    .login-features {
        position: relative;
        z-index: 1;
        margin-top: auto;
    }

    .feature-item {
        display: flex;
        align-items: center;
        margin-bottom: 25px;
        gap: 15px;
    }

    .feature-icon {
        width: 50px;
        height: 50px;
        background: rgba(255, 255, 255, 0.15);
        border-radius: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.3rem;
        flex-shrink: 0;
        transition: all 0.3s ease;
    }

    .feature-item:hover .feature-icon {
        background: rgba(255, 255, 255, 0.25);
        transform: translateY(-3px);
    }

    .feature-text h4 {
        font-size: 1.1rem;
        margin-bottom: 5px;
        font-weight: 600;
    }

    .feature-text p {
        font-size: 0.9rem;
        opacity: 0.8;
        margin: 0;
    }

    /* Геометрические элементы */
    .login-shapes {
        position: absolute;
        z-index: 0;
    }

    .shape-login-1 {
        width: 200px;
        height: 200px;
        border: 3px solid rgba(255, 255, 255, 0.1);
        border-radius: 50%;
        top: -100px;
        right: -100px;
        animation: float 20s infinite linear;
    }

    .shape-login-2 {
        width: 150px;
        height: 150px;
        border: 3px solid rgba(255, 255, 255, 0.1);
        border-radius: 30px;
        bottom: 50px;
        left: 50px;
        transform: rotate(45deg);
        animation: float 15s infinite linear reverse;
    }

    .shape-login-3 {
        width: 100px;
        height: 100px;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 20px;
        top: 50%;
        right: 30%;
        transform: rotate(15deg);
        animation: pulse 8s infinite ease-in-out;
    }

    /* Правая панель с формой */
    .login-form-section {
        flex: 1;
        padding: 80px 60px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        position: relative;
    }

    .form-header {
        margin-bottom: 50px;
        text-align: center;
    }

    .form-logo {
        width: 80px;
        height: 80px;
        background: linear-gradient(45deg, var(--mint), var(--coral));
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 25px;
        color: white;
        font-size: 2rem;
        box-shadow: 0 10px 20px rgba(78, 205, 196, 0.3);
    }

    .form-title {
        font-size: 2.2rem;
        color: var(--dark-green);
        font-weight: 700;
        margin-bottom: 10px;
    }

    .form-subtitle {
        color: var(--gray);
        font-size: 1rem;
    }

    /* Кастомная форма */
    .custom-form .form-group {
        margin-bottom: 30px;
    }

    .custom-form label {
        display: block;
        margin-bottom: 10px;
        color: var(--dark-green);
        font-weight: 600;
        font-size: 0.95rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .custom-form .form-control {
        width: 100%;
        padding: 18px 25px;
        border: 2px solid #e0e6eb;
        border-radius: 15px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
        color: var(--dark);
    }

    .custom-form .form-control:focus {
        border-color: var(--mint);
        box-shadow: 0 5px 15px rgba(78, 205, 196, 0.15);
        outline: none;
    }

    .custom-form .form-control::placeholder {
        color: #a8b5c0;
    }

    .input-with-icon {
        position: relative;
    }

    .input-icon {
        position: absolute;
        left: 20px;
        top: 50%;
        transform: translateY(-50%);
        color: var(--gray);
        font-size: 1.1rem;
        z-index: 2;
    }

    .input-with-icon .form-control {
        padding-left: 55px;
    }

    .form-options {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 35px;
    }

    .remember-me {
        display: flex;
        align-items: center;
        gap: 10px;
        cursor: pointer;
    }

    .remember-checkbox {
        width: 20px;
        height: 20px;
        border: 2px solid #e0e6eb;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }

    .remember-checkbox.checked {
        background: var(--mint);
        border-color: var(--mint);
    }

    .remember-checkbox.checked::after {
        content: '✓';
        color: white;
        font-size: 0.8rem;
        font-weight: bold;
    }

    .remember-text {
        color: var(--gray);
        font-size: 0.9rem;
        user-select: none;
    }

    .forgot-password {
        color: var(--mint);
        text-decoration: none;
        font-size: 0.9rem;
        font-weight: 500;
        transition: color 0.3s ease;
    }

    .forgot-password:hover {
        color: var(--dark-green);
    }

    /* Кнопка входа */
    .login-button {
        width: 100%;
        padding: 18px;
        background: linear-gradient(45deg, var(--coral), #ff8e8e);
        color: white;
        border: none;
        border-radius: 15px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
        margin-bottom: 30px;
    }

    .login-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, var(--mint), #6ce6dd);
        transition: left 0.5s ease;
        z-index: 1;
    }

    .login-button:hover::before {
        left: 0;
    }

    .login-button span {
        position: relative;
        z-index: 2;
    }

    .login-button:hover {
        transform: translateY(-3px);
        box-shadow: 0 15px 30px rgba(255, 107, 107, 0.3);
    }

    /* Разделитель */
    .form-divider {
        display: flex;
        align-items: center;
        margin: 30px 0;
        color: var(--gray);
        font-size: 0.9rem;
    }

    .divider-line {
        flex: 1;
        height: 1px;
        background: #e0e6eb;
    }

    .divider-text {
        padding: 0 20px;
    }

    /* Альтернативные способы входа */
    .social-login {
        display: flex;
        gap: 15px;
        margin-bottom: 40px;
    }

    .social-button {
        flex: 1;
        padding: 15px;
        border: 2px solid #e0e6eb;
        border-radius: 15px;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 500;
        color: var(--dark);
    }

    .social-button:hover {
        border-color: var(--mint);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .social-icon {
        font-size: 1.2rem;
    }

    .google .social-icon { color: #DB4437; }
    .facebook .social-icon { color: #4267B2; }
    .vk .social-icon { color: #4C75A3; }

    /* Ссылка на регистрацию */
    .register-link {
        text-align: center;
        margin-top: auto;
        padding-top: 30px;
        border-top: 1px solid #e0e6eb;
    }

    .register-link p {
        color: var(--gray);
        margin-bottom: 15px;
        font-size: 0.95rem;
    }

    .register-button {
        display: inline-block;
        padding: 15px 40px;
        border: 2px solid var(--mint);
        border-radius: 50px;
        color: var(--mint);
        text-decoration: none;
        font-weight: 600;
        font-size: 1rem;
        transition: all 0.3s ease;
    }

    .register-button:hover {
        background: var(--mint);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(78, 205, 196, 0.2);
    }

    /* Анимации */
    @keyframes float {
        0% { transform: translate(0, 0) rotate(0deg); }
        33% { transform: translate(30px, -30px) rotate(120deg); }
        66% { transform: translate(-20px, 20px) rotate(240deg); }
        100% { transform: translate(0, 0) rotate(360deg); }
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1) rotate(15deg); opacity: 0.5; }
        50% { transform: scale(1.1) rotate(15deg); opacity: 0.8; }
    }

    /* Адаптивность */
    @media (max-width: 992px) {
        .login-container {
            flex-direction: column;
            max-width: 600px;
            min-height: auto;
        }

        .login-hero {
            padding: 40px 30px;
            min-height: 300px;
        }

        .login-title {
            font-size: 2.2rem;
        }

        .login-form-section {
            padding: 50px 40px;
        }

        .shape-login-1,
        .shape-login-2,
        .shape-login-3 {
            display: none;
        }
    }

    @media (max-width: 576px) {
        .login-form-section {
            padding: 40px 25px;
        }

        .form-title {
            font-size: 1.8rem;
        }

        .social-login {
            flex-direction: column;
        }

        .login-hero {
            padding: 30px 20px;
        }

        .login-title {
            font-size: 1.8rem;
        }
    }
</style>

<div class="login-page">
    <div class="login-container">
        <!-- Левая панель -->
        <div class="login-hero">
            <div class="login-shapes">
                <div class="shape-login-1"></div>
                <div class="shape-login-2"></div>
                <div class="shape-login-3"></div>
            </div>

            <div>
                <h1 class="login-title">Вернитесь в мир приключений</h1>
                <p class="login-subtitle">Войдите в свой аккаунт, чтобы продолжить планирование незабываемых путешествий и получить доступ к эксклюзивным предложениям.</p>
            </div>

            <div class="login-features">
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <div class="feature-text">
                        <h4>Мгновенный доступ</h4>
                        <p>К вашим забронированным турам и истории заказов</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="feature-text">
                        <h4>Эксклюзивные предложения</h4>
                        <p>Специальные цены и ранний доступ к новым маршрутам</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div class="feature-text">
                        <h4>Безопасность данных</h4>
                        <p>Ваша информация защищена по стандартам шифрования</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Правая панель с формой -->
        <div class="login-form-section">
            <div class="form-header">
                <div class="form-logo">
                    <i class="fas fa-compass"></i>
                </div>
                <h2 class="form-title">С возвращением!</h2>
                <p class="form-subtitle">Введите данные для входа в аккаунт</p>
            </div>

            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'options' => ['class' => 'custom-form'],
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'errorOptions' => ['class' => 'invalid-feedback'],
                ],
            ]); ?>

            <div class="form-group">
                <div class="input-with-icon">
                    <i class="fas fa-envelope input-icon"></i>
                    <?= $form->field($model, 'email', [
                        'options' => ['tag' => false],
                        'inputOptions' => [
                            'class' => 'form-control',
                            'placeholder' => 'your.email@example.com'
                        ]
                    ])->label('Электронная почта')->textInput(['autofocus' => true]) ?>
                </div>
            </div>

            <div class="form-group">
                <div class="input-with-icon">
                    <i class="fas fa-lock input-icon"></i>
                    <?= $form->field($model, 'password', [
                        'options' => ['tag' => false],
                        'inputOptions' => [
                            'class' => 'form-control',
                            'placeholder' => '••••••••'
                        ]
                    ])->label('Пароль')->passwordInput() ?>
                </div>
            </div>

            <div class="form-options">
                <div class="remember-me" id="rememberMe">
                    <div class="remember-checkbox" id="rememberCheckbox"></div>
                    <span class="remember-text">Запомнить меня</span>
                </div>

                <a href="#" class="forgot-password">Забыли пароль?</a>
            </div>

            <button type="submit" class="login-button">
                <span>Войти в аккаунт</span>
            </button>

            <?php ActiveForm::end(); ?>

            <div class="form-divider">
                <div class="divider-line"></div>
                <div class="divider-text">или войдите через</div>
                <div class="divider-line"></div>
            </div>

            <div class="social-login">
                <button type="button" class="social-button google">
                    <i class="fab fa-google social-icon"></i>
                    <span>Google</span>
                </button>
                <button type="button" class="social-button facebook">
                    <i class="fab fa-facebook-f social-icon"></i>
                    <span>Facebook</span>
                </button>
                <button type="button" class="social-button vk">
                    <i class="fab fa-vk social-icon"></i>
                    <span>ВКонтакте</span>
                </button>
            </div>

            <div class="register-link">
                <p>Еще нет аккаунта?</p>
                <a href="<?= \yii\helpers\Url::to(['site/register']) ?>" class="register-button">
                    Создать аккаунт
                </a>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Обработка чекбокса "Запомнить меня"
        const rememberMe = document.getElementById('rememberMe');
        const rememberCheckbox = document.getElementById('rememberCheckbox');

        if (rememberMe) {
            rememberMe.addEventListener('click', function() {
                rememberCheckbox.classList.toggle('checked');
            });
        }

        // Анимация появления элементов
        const formElements = document.querySelectorAll('.form-group, .form-options, .login-button');
        formElements.forEach((element, index) => {
            element.style.opacity = '0';
            element.style.transform = 'translateY(20px)';

            setTimeout(() => {
                element.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
            }, 100 + index * 100);
        });

        // Валидация формы
        const loginForm = document.getElementById('login-form');
        const emailInput = document.querySelector('input[name="LoginForm[email]"]');
        const passwordInput = document.querySelector('input[name="LoginForm[password]"]');

        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }

        function showError(input, message) {
            const formGroup = input.closest('.form-group');
            let errorDiv = formGroup.querySelector('.invalid-feedback');

            if (!errorDiv) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'invalid-feedback';
                formGroup.appendChild(errorDiv);
            }

            errorDiv.textContent = message;
            input.style.borderColor = 'var(--coral)';
            errorDiv.style.display = 'block';
        }

        function clearError(input) {
            const formGroup = input.closest('.form-group');
            const errorDiv = formGroup.querySelector('.invalid-feedback');

            if (errorDiv) {
                errorDiv.style.display = 'none';
            }

            input.style.borderColor = '#e0e6eb';
        }

        if (emailInput) {
            emailInput.addEventListener('blur', function() {
                if (!this.value.trim()) {
                    showError(this, 'Пожалуйста, введите email');
                } else if (!validateEmail(this.value)) {
                    showError(this, 'Введите корректный email адрес');
                } else {
                    clearError(this);
                }
            });

            emailInput.addEventListener('focus', function() {
                clearError(this);
            });
        }

        if (passwordInput) {
            passwordInput.addEventListener('blur', function() {
                if (!this.value.trim()) {
                    showError(this, 'Пожалуйста, введите пароль');
                } else if (this.value.length < 6) {
                    showError(this, 'Пароль должен содержать не менее 6 символов');
                } else {
                    clearError(this);
                }
            });

            passwordInput.addEventListener('focus', function() {
                clearError(this);
            });
        }

        // Эффект при отправке формы
        if (loginForm) {
            loginForm.addEventListener('submit', function(e) {
                const button = this.querySelector('.login-button');
                if (button) {
                    button.innerHTML = '<span><i class="fas fa-spinner fa-spin"></i> Вход...</span>';
                    button.style.opacity = '0.8';
                    button.disabled = true;
                }
            });
        }

        // Анимация для социальных кнопок
        const socialButtons = document.querySelectorAll('.social-button');
        socialButtons.forEach(button => {
            button.addEventListener('mouseenter', function() {
                const icon = this.querySelector('.social-icon');
                icon.style.transform = 'scale(1.2)';
                icon.style.transition = 'transform 0.3s ease';
            });

            button.addEventListener('mouseleave', function() {
                const icon = this.querySelector('.social-icon');
                icon.style.transform = 'scale(1)';
            });
        });
    });
</script>